/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregator;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.TestFloatColumnSelector;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.junit.Assert;
import org.junit.Test;

public class FilteredAggregatorTest {
    private void aggregate(TestFloatColumnSelector selector, FilteredAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        double expectedSecond;
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "a", null));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedThird = expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }

    private ColumnSelectorFactory makeColumnSelector(final TestFloatColumnSelector selector) {
        return new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                String dimensionName = dimensionSpec.getDimension();
                if ("dim".equals(dimensionName)) {
                    return dimensionSpec.decorate((DimensionSelector)new AbstractDimensionSelector(){

                        public IndexedInts getRow() {
                            SingleIndexedInt row = new SingleIndexedInt();
                            if (selector.getIndex() % 3 == 2) {
                                row.setValue(1);
                            } else {
                                row.setValue(0);
                            }
                            return row;
                        }

                        public ValueMatcher makeValueMatcher(String value) {
                            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
                        }

                        public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                        }

                        public int getValueCardinality() {
                            return 2;
                        }

                        public String lookupName(int id) {
                            switch (id) {
                                case 0: {
                                    return "a";
                                }
                                case 1: {
                                    return "b";
                                }
                            }
                            throw new IllegalArgumentException();
                        }

                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Nullable
                        public IdLookup idLookup() {
                            return new IdLookup(){

                                public int lookupId(String name) {
                                    switch (name) {
                                        case "a": {
                                            return 0;
                                        }
                                        case "b": {
                                            return 1;
                                        }
                                    }
                                    throw new IllegalArgumentException();
                                }
                            };
                        }

                        public Class classOfObject() {
                            return Object.class;
                        }

                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        }
                    });
                }
                throw new UnsupportedOperationException();
            }

            public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
                if ("value".equals(columnName)) {
                    return selector;
                }
                throw new UnsupportedOperationException();
            }

            public ColumnCapabilities getColumnCapabilities(String columnName) {
                ColumnCapabilitiesImpl caps;
                if ("value".equals(columnName)) {
                    caps = new ColumnCapabilitiesImpl();
                    caps.setType(ValueType.FLOAT);
                    caps.setDictionaryEncoded(false);
                    caps.setHasBitmapIndexes(false);
                } else {
                    caps = new ColumnCapabilitiesImpl();
                    caps.setType(ValueType.STRING);
                    caps.setDictionaryEncoded(true);
                    caps.setHasBitmapIndexes(true);
                }
                return caps;
            }
        };
    }

    private void assertValues(FilteredAggregator agg, TestFloatColumnSelector selector, double ... expectedVals) {
        Assert.assertEquals((Object)NullHandling.defaultDoubleValue(), (Object)agg.get());
        Assert.assertEquals((Object)NullHandling.defaultDoubleValue(), (Object)agg.get());
        Assert.assertEquals((Object)NullHandling.defaultDoubleValue(), (Object)agg.get());
        for (double expectedVal : expectedVals) {
            this.aggregate(selector, agg);
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
        }
    }

    @Test
    public void testAggregateWithNotFilter() {
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b", null)));
        this.validateFilteredAggs(factory, values, selector);
    }

    @Test
    public void testAggregateWithOrFilter() {
        float[] values = new float[]{0.15f, 0.27f, 0.14f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new OrDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("dim", "a", null), new SelectorDimFilter("dim", "b", null)})));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        double expectedThird = expectedSecond + new Float(values[2]).doubleValue();
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }

    @Test
    public void testAggregateWithAndFilter() {
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b", null)), new SelectorDimFilter("dim", "a", null)})));
        this.validateFilteredAggs(factory, values, selector);
    }

    @Test
    public void testAggregateWithPredicateFilters() {
        float[] values = new float[]{0.15f, 0.27f};
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new BoundDimFilter("dim", "a", "a", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC));
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new RegexDimFilter("dim", "a", null));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SearchQueryDimFilter("dim", (SearchQuerySpec)new ContainsSearchQuerySpec("a", true), null));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        String jsFn = "function(x) { return(x === 'a') }";
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new JavaScriptDimFilter("dim", jsFn, null, JavaScriptConfig.getEnabledInstance()));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
    }

    @Test
    public void testAggregateWithExtractionFns() {
        float[] values = new float[]{0.15f, 0.27f};
        String extractionJsFn = "function(str) { return str + 'AARDVARK'; }";
        JavaScriptExtractionFn extractionFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "aAARDVARK", (ExtractionFn)extractionFn));
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new InDimFilter("dim", Arrays.asList("NOT-aAARDVARK", "FOOBAR", "aAARDVARK"), (ExtractionFn)extractionFn));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new BoundDimFilter("dim", "aAARDVARK", "aAARDVARK", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)extractionFn, StringComparators.ALPHANUMERIC));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new RegexDimFilter("dim", "aAARDVARK", (ExtractionFn)extractionFn));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SearchQueryDimFilter("dim", (SearchQuerySpec)new ContainsSearchQuerySpec("aAARDVARK", true), (ExtractionFn)extractionFn));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        String jsFn = "function(x) { return(x === 'aAARDVARK') }";
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new JavaScriptDimFilter("dim", jsFn, (ExtractionFn)extractionFn, JavaScriptConfig.getEnabledInstance()));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
    }

    private void validateFilteredAggs(FilteredAggregatorFactory factory, float[] values, TestFloatColumnSelector selector) {
        double expectedSecond;
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedThird = expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }
}

