/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleAnyAggregationTest
extends InitializedNullHandlingTest {
    private DoubleAnyAggregatorFactory doubleAnyAggFactory;
    private DoubleAnyAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestDoubleColumnSelectorImpl valueSelector;
    private TestObjectColumnSelector objectSelector;
    private double[] doubles = new double[]{1.1897, 0.001, 86.23, 166.228};
    private Double[] objects = new Double[]{2.1897, 1.001, 87.23, 167.228};

    @Before
    public void setup() {
        this.doubleAnyAggFactory = new DoubleAnyAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (DoubleAnyAggregatorFactory)this.doubleAnyAggFactory.getCombiningFactory();
        this.valueSelector = new TestDoubleColumnSelectorImpl(this.doubles);
        this.objectSelector = new TestObjectColumnSelector<Double>(this.objects);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testDoubleAnyAggregator() {
        Aggregator agg = this.doubleAnyAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Double result = (Double)agg.get();
        Assert.assertEquals((Object)this.doubles[0], (Object)result);
        Assert.assertEquals((long)((long)this.doubles[0]), (long)agg.getLong());
        Assert.assertEquals((double)this.doubles[0], (double)agg.getDouble(), (double)1.0E-4);
    }

    @Test
    public void testDoubleAnyBufferAggregator() {
        BufferAggregator agg = this.doubleAnyAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.doubleAnyAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Double result = (Double)agg.get(buffer, 0);
        Assert.assertEquals((double)this.doubles[0], (double)result, (double)1.0E-4);
        Assert.assertEquals((long)((long)this.doubles[0]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.doubles[0], (double)agg.getDouble(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        Double d1 = 3.0;
        Double d2 = 4.0;
        Assert.assertEquals((Object)d1, (Object)this.doubleAnyAggFactory.combine((Object)d1, (Object)d2));
    }

    @Test
    public void testComparatorWithNulls() {
        Double d1 = 3.0;
        Object d2 = null;
        Comparator comparator = this.doubleAnyAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(d1, d2));
        Assert.assertEquals((long)0L, (long)comparator.compare(d1, d1));
        Assert.assertEquals((long)0L, (long)comparator.compare(d2, d2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(d2, d1));
    }

    @Test
    public void testDoubleAnyCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Double result = (Double)agg.get();
        Assert.assertEquals((double)this.objects[0], (double)result, (double)1.0E-4);
        Assert.assertEquals((long)this.objects[0].longValue(), (long)agg.getLong());
        Assert.assertEquals((double)this.objects[0], (double)agg.getDouble(), (double)1.0E-4);
    }

    @Test
    public void testDoubleAnyCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.doubleAnyAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Double result = (Double)agg.get(buffer, 0);
        Assert.assertEquals((double)this.objects[0], (double)result, (double)1.0E-4);
        Assert.assertEquals((long)this.objects[0].longValue(), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.objects[0], (double)agg.getDouble(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String doubleSpecJson = "{\"type\":\"doubleAny\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.doubleAnyAggFactory, (Object)mapper.readValue(doubleSpecJson, AggregatorFactory.class));
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

