/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringAnyAggregationTest {
    private final Integer MAX_STRING_SIZE = 1024;
    private AggregatorFactory stringAnyAggFactory;
    private AggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestObjectColumnSelector<String> valueSelector;
    private TestObjectColumnSelector objectSelector;
    private String[] strings = new String[]{"1111", "2222", "3333", null, "4444"};
    private String[] stringsWithNullFirst = new String[]{null, "1111", "2222", "3333", null, "4444"};

    @Before
    public void setup() {
        this.stringAnyAggFactory = new StringAnyAggregatorFactory("billy", "nilly", this.MAX_STRING_SIZE);
        this.combiningAggFactory = this.stringAnyAggFactory.getCombiningFactory();
        this.valueSelector = new TestObjectColumnSelector<String>(this.strings);
        this.objectSelector = new TestObjectColumnSelector<String>(this.strings);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn(this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ValueType.STRING));
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("billy")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testStringAnyAggregator() {
        Aggregator agg = this.stringAnyAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        String result = (String)agg.get();
        Assert.assertEquals((Object)this.strings[0], (Object)result);
    }

    @Test
    public void testStringAnyAggregatorWithNullFirst() {
        this.valueSelector = new TestObjectColumnSelector<String>(this.stringsWithNullFirst);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ValueType.STRING));
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn(this.valueSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
        Aggregator agg = this.stringAnyAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        String result = (String)agg.get();
        Assert.assertNull((Object)result);
    }

    @Test
    public void testStringAnyBufferAggregator() {
        BufferAggregator agg = this.stringAnyAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.stringAnyAggFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        String result = (String)agg.get(buffer, 0);
        Assert.assertEquals((Object)this.strings[0], (Object)result);
    }

    @Test
    public void testStringAnyBufferAggregatorWithNullFirst() {
        this.valueSelector = new TestObjectColumnSelector<String>(this.stringsWithNullFirst);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ValueType.STRING));
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn(this.valueSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
        BufferAggregator agg = this.stringAnyAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.stringAnyAggFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        String result = (String)agg.get(buffer, 0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testCombine() {
        String s1 = "aaaaaa";
        String s2 = "aaaaaa";
        Assert.assertEquals((Object)s1, (Object)this.stringAnyAggFactory.combine((Object)s1, (Object)s2));
    }

    @Test
    public void testStringAnyCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        String result = (String)agg.get();
        Assert.assertEquals((Object)this.strings[0], (Object)result);
        Assert.assertEquals((Object)this.strings[0], (Object)result);
    }

    @Test
    public void testStringAnyCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.stringAnyAggFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        String result = (String)agg.get(buffer, 0);
        Assert.assertEquals((Object)this.strings[0], (Object)result);
        Assert.assertEquals((Object)this.strings[0], (Object)result);
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

