/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongFirstAggregationTest
extends InitializedNullHandlingTest {
    private LongFirstAggregatorFactory longFirstAggFactory;
    private LongFirstAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestLongColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private long[] longValues = new long[]{185L, -216L, -128751132L, Long.MIN_VALUE};
    private long[] times = new long[]{1123126751L, 1784247991L, 1854329816L, 1000000000L};
    private SerializablePair[] pairs = new SerializablePair[]{new SerializablePair((Object)1L, (Object)113267L), new SerializablePair((Object)1L, (Object)5437384L), new SerializablePair((Object)6L, (Object)34583458L), new SerializablePair((Object)88L, (Object)34583452L)};

    @Before
    public void setup() {
        this.longFirstAggFactory = new LongFirstAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (LongFirstAggregatorFactory)this.longFirstAggFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.valueSelector = new TestLongColumnSelector(this.longValues);
        this.objectSelector = new TestObjectColumnSelector<SerializablePair>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testLongFirstAggregator() {
        Aggregator agg = this.longFirstAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[3], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[3], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[3], (long)agg.getLong());
        Assert.assertEquals((double)this.longValues[3], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testLongFirstBufferAggregator() {
        BufferAggregator agg = this.longFirstAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longFirstAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[3], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[3], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[3], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.longValues[3], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)1263L);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)752713L);
        Assert.assertEquals((Object)pair1, (Object)this.longFirstAggFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testComparatorWithNulls() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)1263L);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, null);
        Comparator comparator = this.longFirstAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(pair1, pair2));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair1, pair1));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair2, pair2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(pair2, pair1));
    }

    @Test
    public void testLongFirstCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePair expected = this.pairs[0];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong());
        Assert.assertEquals((double)((Long)expected.rhs).longValue(), (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testLongFirstCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longFirstAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePair expected = this.pairs[0];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)((Long)expected.rhs).longValue(), (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String longSpecJson = "{\"type\":\"longFirst\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.longFirstAggFactory, (Object)mapper.readValue(longSpecJson, AggregatorFactory.class));
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

