/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.junit.Assert;
import org.junit.Test;

public class StringLastBufferAggregatorTest {
    private void aggregateBuffer(TestLongColumnSelector timeSelector, TestObjectColumnSelector valueSelector, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        timeSelector.increment();
        valueSelector.increment();
    }

    @Test
    public void testBufferAggregate() {
        long[] timestamps = new long[]{1526724600L, 1526724700L, 1526724800L, 1526725900L, 1526725000L};
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "billy", maxStringBytes);
        StringLastBufferAggregator agg = new StringLastBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), false);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((String)"expected last string value", (Object)"DDDD", (Object)sp.rhs);
        Assert.assertEquals((String)"last string timestamp is the biggest", (Object)new Long(1526725900L), (Object)sp.lhs);
    }

    @Test
    public void testBufferAggregateWithFoldCheck() {
        long[] timestamps = new long[]{1526724600L, 1526724700L, 1526724800L, 1526725900L, 1526725000L};
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "billy", maxStringBytes);
        StringLastBufferAggregator agg = new StringLastBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), true);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((String)"expected last string value", (Object)"DDDD", (Object)sp.rhs);
        Assert.assertEquals((String)"last string timestamp is the biggest", (Object)new Long(1526725900L), (Object)sp.lhs);
    }

    @Test
    public void testNullBufferAggregate() {
        long[] timestamps = new long[]{1111L, 2222L, 6666L, 4444L, 5555L};
        String[] strings = new String[]{"CCCC", "AAAA", "BBBB", null, "EEEE"};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "billy", maxStringBytes);
        StringLastBufferAggregator agg = new StringLastBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), false);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((String)"expected last string value", (Object)strings[2], (Object)sp.rhs);
        Assert.assertEquals((String)"last string timestamp is the biggest", (Object)new Long(timestamps[2]), (Object)sp.lhs);
    }

    @Test
    public void testNonStringValue() {
        long[] timestamps = new long[]{1526724000L, 1526724600L};
        Double[] doubles = new Double[]{null, 2.0};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<Double> objectColumnSelector = new TestObjectColumnSelector<Double>(doubles);
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "billy", maxStringBytes);
        StringLastBufferAggregator agg = new StringLastBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), false);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((long)1526724600L, (long)((Long)sp.lhs));
        Assert.assertEquals((Object)"2.0", (Object)sp.rhs);
    }
}

