/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.mean;

import org.apache.druid.query.aggregation.mean.DoubleMeanAggregatorFactory;
import org.apache.druid.query.aggregation.mean.DoubleMeanHolder;
import org.junit.Assert;
import org.junit.Test;

public class DoubleMeanAggregatorFactoryTest {
    @Test
    public void testMaxIntermediateSize() {
        DoubleMeanAggregatorFactory factory = new DoubleMeanAggregatorFactory("name", "fieldName");
        Assert.assertEquals((long)16L, (long)factory.getMaxIntermediateSize());
        Assert.assertEquals((long)16L, (long)factory.getMaxIntermediateSizeWithNulls());
    }

    @Test
    public void testDeserialyze() {
        DoubleMeanAggregatorFactory factory = new DoubleMeanAggregatorFactory("name", "fieldName");
        DoubleMeanHolder expectedHolder = new DoubleMeanHolder(50.0, 10L);
        DoubleMeanHolder actualHolder = (DoubleMeanHolder)factory.deserialize((Object)expectedHolder);
        Assert.assertEquals((Object)expectedHolder, (Object)actualHolder);
        actualHolder = (DoubleMeanHolder)factory.deserialize((Object)expectedHolder.toBytes());
        Assert.assertEquals((Object)expectedHolder, (Object)actualHolder);
    }

    @Test
    public void testFinalizeComputation() {
        DoubleMeanAggregatorFactory factory = new DoubleMeanAggregatorFactory("name", "fieldName");
        double sum = 50.0;
        long count = 10L;
        double expecterMean = sum / (double)count;
        DoubleMeanHolder holder = new DoubleMeanHolder(sum, count);
        double actualMean = (Double)factory.finalizeComputation((Object)holder);
        Assert.assertEquals((String)"", (double)expecterMean, (double)actualMean, (double)1.0E-6);
        actualMean = (Double)factory.finalizeComputation((Object)holder.toBytes());
        Assert.assertEquals((String)"", (double)expecterMean, (double)actualMean, (double)1.0E-6);
        Assert.assertNull((Object)factory.finalizeComputation(null));
    }
}

