/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregator;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ArithmeticPostAggregatorTest
extends InitializedNullHandlingTest {
    @Test
    public void testCompute() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put("rows", agg.get());
        ArrayList postAggregatorList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)6.0), new FieldAccessPostAggregator("rows", "rows")});
        for (PostAggregator postAggregator : postAggregatorList) {
            metricValues.put(postAggregator.getName(), postAggregator.compute(metricValues));
        }
        ArithmeticPostAggregator arithmeticPostAggregator = new ArithmeticPostAggregator("add", "+", (List)postAggregatorList);
        ExpressionPostAggregator expressionPostAggregator = new ExpressionPostAggregator("add", "roku + rows", null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)9.0, (Object)arithmeticPostAggregator.compute(metricValues));
        Assert.assertEquals((Object)9.0, (Object)expressionPostAggregator.compute(metricValues));
        arithmeticPostAggregator = new ArithmeticPostAggregator("subtract", "-", (List)postAggregatorList);
        expressionPostAggregator = new ExpressionPostAggregator("add", "roku - rows", null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)3.0, (Object)arithmeticPostAggregator.compute(metricValues));
        Assert.assertEquals((Object)3.0, (Object)expressionPostAggregator.compute(metricValues));
        arithmeticPostAggregator = new ArithmeticPostAggregator("multiply", "*", (List)postAggregatorList);
        expressionPostAggregator = new ExpressionPostAggregator("add", "roku * rows", null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)18.0, (Object)arithmeticPostAggregator.compute(metricValues));
        Assert.assertEquals((Object)18.0, (Object)expressionPostAggregator.compute(metricValues));
        arithmeticPostAggregator = new ArithmeticPostAggregator("divide", "/", (List)postAggregatorList);
        expressionPostAggregator = new ExpressionPostAggregator("add", "roku / rows", null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)2.0, (Object)arithmeticPostAggregator.compute(metricValues));
        Assert.assertEquals((Object)2.0, (Object)expressionPostAggregator.compute(metricValues));
    }

    @Test
    public void testComparator() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put("rows", agg.get());
        ArrayList postAggregatorList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)6.0), new FieldAccessPostAggregator("rows", "rows")});
        ArithmeticPostAggregator arithmeticPostAggregator = new ArithmeticPostAggregator("add", "+", (List)postAggregatorList);
        Comparator comp = arithmeticPostAggregator.getComparator();
        Object before = arithmeticPostAggregator.compute(metricValues);
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        metricValues.put("rows", agg.get());
        Object after = arithmeticPostAggregator.compute(metricValues);
        Assert.assertEquals((long)-1L, (long)comp.compare(before, after));
        Assert.assertEquals((long)0L, (long)comp.compare(before, before));
        Assert.assertEquals((long)0L, (long)comp.compare(after, after));
        Assert.assertEquals((long)1L, (long)comp.compare(after, before));
    }

    @Test
    public void testComparatorNulls() {
        String aggName = "doubleWithNulls";
        HashMap<String, Double> metricValues = new HashMap<String, Double>();
        ArrayList postAggregatorList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)6.0), new FieldAccessPostAggregator("doubleWithNulls", "doubleWithNulls")});
        ArithmeticPostAggregator arithmeticPostAggregator = new ArithmeticPostAggregator("add", "+", (List)postAggregatorList);
        Comparator comp = arithmeticPostAggregator.getComparator();
        metricValues.put("doubleWithNulls", NullHandling.replaceWithDefault() ? NullHandling.defaultDoubleValue() : null);
        Object before = arithmeticPostAggregator.compute(metricValues);
        metricValues.put("doubleWithNulls", 1.0);
        Object after = arithmeticPostAggregator.compute(metricValues);
        Assert.assertEquals((long)-1L, (long)comp.compare(before, after));
        Assert.assertEquals((long)0L, (long)comp.compare(before, before));
        Assert.assertEquals((long)0L, (long)comp.compare(after, after));
        Assert.assertEquals((long)1L, (long)comp.compare(after, before));
    }

    @Test
    public void testQuotient() {
        ArithmeticPostAggregator agg = new ArithmeticPostAggregator(null, "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator("numerator", "value"), (Object)new ConstantPostAggregator("zero", (Number)0)), "numericFirst");
        Assert.assertEquals((Object)Double.NaN, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)0)));
        Assert.assertEquals((Object)Double.NaN, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)Double.NaN)));
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)1)));
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)-1)));
    }

    @Test
    public void testDiv() {
        ArithmeticPostAggregator agg = new ArithmeticPostAggregator(null, "/", (List)ImmutableList.of((Object)new FieldAccessPostAggregator("numerator", "value"), (Object)new ConstantPostAggregator("denomiator", (Number)0)));
        Assert.assertEquals((Object)0.0, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)0)));
        Assert.assertEquals((Object)0.0, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)Double.NaN)));
        Assert.assertEquals((Object)0.0, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)1)));
        Assert.assertEquals((Object)0.0, (Object)agg.compute((Map)ImmutableMap.of((Object)"value", (Object)-1)));
    }

    @Test
    public void testNumericFirstOrdering() {
        ArithmeticPostAggregator agg = new ArithmeticPostAggregator(null, "quotient", (List)ImmutableList.of((Object)new ConstantPostAggregator("zero", (Number)0), (Object)new ConstantPostAggregator("zero", (Number)0)), "numericFirst");
        Comparator numericFirst = agg.getComparator();
        Assert.assertTrue((numericFirst.compare(Double.NaN, 0.0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.POSITIVE_INFINITY, 0.0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.NEGATIVE_INFINITY, 0.0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(0.0, Double.NaN) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(0.0, Double.POSITIVE_INFINITY) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(0.0, Double.NEGATIVE_INFINITY) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.NaN, Double.POSITIVE_INFINITY) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.NaN, Double.NEGATIVE_INFINITY) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.POSITIVE_INFINITY, Double.NaN) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((numericFirst.compare(Double.NEGATIVE_INFINITY, Double.NaN) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "col"), new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator("avg", "/", (List)ImmutableList.of((Object)new FieldAccessPostAggregator("_count", "count"), (Object)new FieldAccessPostAggregator("_sum", "sum")))}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("sum", ValueType.LONG).add("count", ValueType.LONG).add("avg", ValueType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

