/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregator;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.LongLeastPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class LongLeastPostAggregatorTest {
    @Test
    public void testCompute() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put("rows", agg.get());
        ArrayList postAggregatorList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)6.0), new FieldAccessPostAggregator("rows", "rows")});
        LongLeastPostAggregator leastPostAggregator = new LongLeastPostAggregator("leastPostAggregator", (List)postAggregatorList);
        Assert.assertEquals((Object)3L, (Object)leastPostAggregator.compute(metricValues));
    }

    @Test
    public void testComparator() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put("rows", agg.get());
        ArrayList postAggregatorList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)2.0), new FieldAccessPostAggregator("rows", "rows")});
        LongLeastPostAggregator leastPostAggregator = new LongLeastPostAggregator("leastPostAggregator", (List)postAggregatorList);
        Comparator comp = leastPostAggregator.getComparator();
        Object before = leastPostAggregator.compute(metricValues);
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        metricValues.put("rows", agg.get());
        Object after = leastPostAggregator.compute(metricValues);
        Assert.assertEquals((long)-1L, (long)comp.compare(before, after));
        Assert.assertEquals((long)0L, (long)comp.compare(before, before));
        Assert.assertEquals((long)0L, (long)comp.compare(after, after));
        Assert.assertEquals((long)1L, (long)comp.compare(after, before));
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new LongLeastPostAggregator("a", (List)ImmutableList.of((Object)new ConstantPostAggregator("_a", (Number)3L), (Object)new ConstantPostAggregator("_b", (Number)Float.valueOf(1.0f)), (Object)new ConstantPostAggregator("_c", (Number)5.0)))}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("a", ValueType.LONG).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

