/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;

public class StringDimensionSelectorForTest
extends AbstractDimensionSelector {
    private final Supplier<List<String>> rowSupplier;
    private final boolean unknownCardinality;
    private final boolean validIdLookup;
    private final boolean nameLookupPossibleInAdvance;
    private final Object2IntMap<String> dictionary;
    private final Int2ObjectMap<String> reverseDictionary;
    private final ArrayBasedIndexedInts currentRow = new ArrayBasedIndexedInts();

    public StringDimensionSelectorForTest(Supplier<List<String>> rowSupplier, Object2IntMap<String> dictionary, Int2ObjectMap<String> reverseDictionary, boolean unknownCardinality, boolean validIdLookup, boolean nameLookupPossibleInAdvance) {
        this.rowSupplier = rowSupplier;
        this.unknownCardinality = unknownCardinality;
        this.validIdLookup = validIdLookup;
        this.nameLookupPossibleInAdvance = nameLookupPossibleInAdvance;
        this.dictionary = dictionary;
        this.reverseDictionary = reverseDictionary;
    }

    public int getValueCardinality() {
        return this.unknownCardinality ? -1 : this.dictionary.size();
    }

    @Nullable
    public String lookupName(int id) {
        return (String)this.reverseDictionary.get(id);
    }

    public boolean nameLookupPossibleInAdvance() {
        return this.nameLookupPossibleInAdvance;
    }

    @Nullable
    public IdLookup idLookup() {
        return this.validIdLookup ? arg_0 -> this.dictionary.getInt(arg_0) : null;
    }

    public IndexedInts getRow() {
        List<String> multiValues = this.rowSupplier.get();
        this.currentRow.ensureSize(multiValues.size());
        for (int i = 0; i < multiValues.size(); ++i) {
            this.currentRow.setValue(i, this.dictionary.getInt((Object)multiValues.get(i)));
        }
        this.currentRow.setSize(multiValues.size());
        return this.currentRow;
    }

    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
    }

    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    public Class<?> classOfObject() {
        return Object.class;
    }
}

