/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.expression.IPv4AddressMatchExprMacro;
import org.apache.druid.query.expression.MacroTestBase;
import org.junit.Assert;
import org.junit.Test;

public class IPv4AddressMatchExprMacroTest
extends MacroTestBase {
    private static final Expr IPV4 = ExprEval.of((String)"192.168.0.1").toExpr();
    private static final Expr IPV4_LONG = ExprEval.of((long)3232235521L).toExpr();
    private static final Expr IPV4_UINT = ExprEval.of((String)"3232235521").toExpr();
    private static final Expr IPV4_NETWORK = ExprEval.of((String)"192.168.0.0").toExpr();
    private static final Expr IPV4_BROADCAST = ExprEval.of((String)"192.168.255.255").toExpr();
    private static final Expr IPV6_COMPATIBLE = ExprEval.of((String)"::192.168.0.1").toExpr();
    private static final Expr IPV6_MAPPED = ExprEval.of((String)"::ffff:192.168.0.1").toExpr();
    private static final Expr SUBNET_192_168 = ExprEval.of((String)"192.168.0.0/16").toExpr();
    private static final Expr SUBNET_10 = ExprEval.of((String)"10.0.0.0/8").toExpr();
    private static final Expr NOT_LITERAL = new NotLiteralExpr(null);

    public IPv4AddressMatchExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new IPv4AddressMatchExprMacro());
    }

    @Test
    public void testTooFewArgs() {
        this.expectException(IllegalArgumentException.class, "must have 2 arguments");
        this.apply(Collections.emptyList());
    }

    @Test
    public void testTooManyArgs() {
        this.expectException(IllegalArgumentException.class, "must have 2 arguments");
        this.apply(Arrays.asList(IPV4, SUBNET_192_168, NOT_LITERAL));
    }

    @Test
    public void testSubnetArgNotLiteral() {
        this.expectException(IllegalArgumentException.class, "subnet arg must be a literal");
        this.apply(Arrays.asList(IPV4, NOT_LITERAL));
    }

    @Test
    public void testSubnetArgInvalid() {
        this.expectException(IllegalArgumentException.class, "subnet arg has an invalid format");
        Expr invalidSubnet = ExprEval.of((String)"192.168.0.1/invalid").toExpr();
        this.apply(Arrays.asList(IPV4, invalidSubnet));
    }

    @Test
    public void testNullStringArg() {
        Expr nullString = ExprEval.of(null).toExpr();
        Assert.assertFalse((boolean)this.eval(nullString, SUBNET_192_168));
    }

    @Test
    public void testNullLongArg() {
        Expr nullLong = ExprEval.ofLong(null).toExpr();
        Assert.assertFalse((boolean)this.eval(nullLong, SUBNET_192_168));
    }

    @Test
    public void testInvalidArgType() {
        Expr longArray = ExprEval.ofLongArray((Long[])new Long[]{1L, 2L}).toExpr();
        Assert.assertFalse((boolean)this.eval(longArray, SUBNET_192_168));
    }

    @Test
    public void testMatchingStringArgIPv4() {
        Assert.assertTrue((boolean)this.eval(IPV4, SUBNET_192_168));
    }

    @Test
    public void testNotMatchingStringArgIPv4() {
        Assert.assertFalse((boolean)this.eval(IPV4, SUBNET_10));
    }

    @Test
    public void testMatchingStringArgIPv6Mapped() {
        Assert.assertFalse((boolean)this.eval(IPV6_MAPPED, SUBNET_192_168));
    }

    @Test
    public void testNotMatchingStringArgIPv6Mapped() {
        Assert.assertFalse((boolean)this.eval(IPV6_MAPPED, SUBNET_10));
    }

    @Test
    public void testMatchingStringArgIPv6Compatible() {
        Assert.assertFalse((boolean)this.eval(IPV6_COMPATIBLE, SUBNET_192_168));
    }

    @Test
    public void testNotMatchingStringArgIPv6Compatible() {
        Assert.assertFalse((boolean)this.eval(IPV6_COMPATIBLE, SUBNET_10));
    }

    @Test
    public void testNotIpAddress() {
        Expr notIpAddress = ExprEval.of((String)"druid.apache.org").toExpr();
        Assert.assertFalse((boolean)this.eval(notIpAddress, SUBNET_192_168));
    }

    @Test
    public void testMatchingLongArg() {
        Assert.assertTrue((boolean)this.eval(IPV4_LONG, SUBNET_192_168));
    }

    @Test
    public void testNotMatchingLongArg() {
        Assert.assertFalse((boolean)this.eval(IPV4_LONG, SUBNET_10));
    }

    @Test
    public void testMatchingStringArgUnsignedInt() {
        Assert.assertFalse((boolean)this.eval(IPV4_UINT, SUBNET_192_168));
    }

    @Test
    public void testNotMatchingStringArgUnsignedInt() {
        Assert.assertFalse((boolean)this.eval(IPV4_UINT, SUBNET_10));
    }

    @Test
    public void testInclusive() {
        Expr subnet = SUBNET_192_168;
        Assert.assertTrue((boolean)this.eval(IPV4_NETWORK, subnet));
        Assert.assertTrue((boolean)this.eval(IPV4, subnet));
        Assert.assertTrue((boolean)this.eval(IPV4_BROADCAST, subnet));
    }

    private boolean eval(Expr ... args) {
        Expr expr = this.apply(Arrays.asList(args));
        ExprEval eval = expr.eval(ExprUtils.nilBindings());
        return eval.asBoolean();
    }

    private static class NotLiteralExpr
    extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
        NotLiteralExpr(Expr arg) {
            super("not", arg);
        }

        public ExprEval eval(Expr.ObjectBinding bindings) {
            return null;
        }

        public Expr visit(Expr.Shuttle shuttle) {
            return null;
        }
    }
}

