/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class InDimFilterTest
extends InitializedNullHandlingTest {
    private ObjectMapper mapper = new DefaultObjectMapper();
    private final String serializedFilter = "{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"]}";

    @Test
    public void testDeserialization() throws IOException {
        InDimFilter actualInDimFilter = (InDimFilter)this.mapper.readerFor(DimFilter.class).readValue("{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"]}");
        InDimFilter expectedInDimFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        Assert.assertEquals((Object)expectedInDimFilter, (Object)actualInDimFilter);
    }

    @Test
    public void testSerialization() throws IOException {
        InDimFilter dimInFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        String actualSerializedFilter = this.mapper.writeValueAsString((Object)dimInFilter);
        Assert.assertEquals((Object)"{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"]}", (Object)actualSerializedFilter);
    }

    @Test
    public void testGetValuesWithValuesSetOfNonEmptyStringsUseTheGivenSet() {
        ImmutableSet values = ImmutableSet.of((Object)"v1", (Object)"v2", (Object)"v3");
        InDimFilter filter = new InDimFilter("dim", (Set)values, null, null);
        Assert.assertSame((Object)values, (Object)filter.getValues());
    }

    @Test
    public void testGetValuesWithValuesSetIncludingEmptyString() {
        HashSet values = Sets.newHashSet((Object[])new String[]{"v1", "", "v3"});
        InDimFilter filter = new InDimFilter("dim", (Set)values, null, null);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertNotSame((Object)values, (Object)filter.getValues());
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"v1", null, "v3"}), (Object)filter.getValues());
        } else {
            Assert.assertSame((Object)values, (Object)filter.getValues());
        }
    }

    @Test
    public void testGetCacheKeyReturningSameKeyForValuesOfDifferentOrders() {
        InDimFilter dimFilter1 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v1", (Object)"v2"), null);
        InDimFilter dimFilter2 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v2", (Object)"v1"), null);
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter2.getCacheKey());
    }

    @Test
    public void testGetCacheKeyForNullVsEmptyString() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList(null, "abc"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Arrays.asList("", "abc"), null);
        if (NullHandling.sqlCompatible()) {
            Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
        } else {
            Assert.assertArrayEquals((byte[])inDimFilter1.getCacheKey(), (byte[])inDimFilter2.getCacheKey());
        }
    }

    @Test
    public void testGetCacheKeyReturningSameKeyForSetsOfDifferentTypesAndComparators() {
        TreeSet<String> reverseOrderSet = new TreeSet<String>(Ordering.natural().reversed());
        InDimFilter dimFilter1 = new InDimFilter("dim", (Set)Sets.newTreeSet(Arrays.asList("v1", "v2")));
        InDimFilter dimFilter2 = new InDimFilter("dim", (Set)Sets.newHashSet((Object[])new String[]{"v2", "v1"}));
        InDimFilter dimFilter3 = new InDimFilter("dim", (Set)ImmutableSortedSet.copyOf(Arrays.asList("v2", "v1")));
        reverseOrderSet.addAll(Arrays.asList("v1", "v2"));
        InDimFilter dimFilter4 = new InDimFilter("dim", reverseOrderSet);
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter2.getCacheKey());
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter3.getCacheKey());
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter4.getCacheKey());
    }

    @Test
    public void testGetCacheKeyDifferentKeysForListOfStringsAndSingleStringOfLists() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Collections.singletonList("good,bad"), null);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyDifferentKeysForNullAndFourZeroChars() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList(null, "abc"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Arrays.asList("\u0000\u0000\u0000\u0000", "abc"), null);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyDifferentKeysWhenStringBoundariesMove() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList("bar", "foo"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Arrays.asList("barf", "oo"), null);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyDifferentKeysForListOfStringsAndSingleStringOfListsWithExtractFn() {
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList("good", "bad"), (ExtractionFn)regexFn);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Collections.singletonList("good,bad"), (ExtractionFn)regexFn);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyNullValue() throws IOException {
        InDimFilter inDimFilter = (InDimFilter)this.mapper.readValue("{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[null]}", InDimFilter.class);
        Assert.assertNotNull((Object)inDimFilter.getCacheKey());
    }

    @Test
    public void testGetCacheKeyReturningDifferentKeysWithAndWithoutNull() {
        InDimFilter filter1 = new InDimFilter("dim", Arrays.asList("val", null), null);
        InDimFilter filter2 = new InDimFilter("dim", Collections.singletonList("val"), null);
        Assert.assertFalse((boolean)Arrays.equals(filter1.getCacheKey(), filter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyReturningCachedCacheKey() {
        InDimFilter filter = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v1", (Object)"v2"), null);
        Assert.assertSame((Object)filter.getCacheKey(), (Object)filter.getCacheKey());
    }

    @Test
    public void testGetDimensionRangeSetValuesOfDifferentOrdersReturningSameResult() {
        InDimFilter dimFilter1 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v1", (Object)"v2", (Object)"v3"), null);
        InDimFilter dimFilter2 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v3", (Object)"v2", (Object)"v1"), null);
        Assert.assertEquals((Object)dimFilter1.getDimensionRangeSet("dim"), (Object)dimFilter2.getDimensionRangeSet("dim"));
    }

    @Test
    public void testOptimizeSingleValueInToSelector() {
        InDimFilter filter = new InDimFilter("dim", Collections.singleton("v1"), null);
        Assert.assertEquals((Object)new SelectorDimFilter("dim", "v1", null), (Object)filter.optimize());
    }

    @Test
    public void testContainsNullWhenValuesSetIsTreeSet() {
        TreeSet<String> values = new TreeSet<String>();
        values.add("foo");
        values.add("bar");
        InDimFilter filter = new InDimFilter("dim", values, null);
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("dim", null);
        RowBasedColumnSelectorFactory columnSelectorFactory = RowBasedColumnSelectorFactory.create((RowAdapter)RowAdapters.standardRow(), () -> new MapBasedRow(0L, row), (RowSignature)RowSignature.builder().add("dim", ValueType.STRING).build(), (boolean)true);
        ValueMatcher matcher = filter.toFilter().makeMatcher((ColumnSelectorFactory)columnSelectorFactory);
        Assert.assertFalse((boolean)matcher.matches());
        row.put("dim", "foo");
        Assert.assertTrue((boolean)matcher.matches());
        row.put("dim", "fox");
        Assert.assertFalse((boolean)matcher.matches());
    }
}

