/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class LikeDimFilterTest
extends InitializedNullHandlingTest {
    @Test
    public void testSerde() throws IOException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        DimFilter filter2 = (DimFilter)objectMapper.readValue(objectMapper.writeValueAsString((Object)filter), DimFilter.class);
        Assert.assertEquals((Object)filter, (Object)filter2);
    }

    @Test
    public void testGetCacheKey() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter2 = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter3 = new LikeDimFilter("foo", "bar%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertArrayEquals((byte[])filter.getCacheKey(), (byte[])filter2.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(filter.getCacheKey(), filter3.getCacheKey()));
    }

    @Test
    public void testEqualsAndHashCode() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter2 = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter3 = new LikeDimFilter("foo", "bar%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertEquals((Object)filter, (Object)filter2);
        Assert.assertNotEquals((Object)filter, (Object)filter3);
        Assert.assertEquals((long)filter.hashCode(), (long)filter2.hashCode());
        Assert.assertNotEquals((long)filter.hashCode(), (long)filter3.hashCode());
    }

    @Test
    public void testGetRequiredColumns() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertEquals((Object)filter.getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"foo"}));
    }

    @Test
    public void testEqualsContractForExtractionFnDruidPredicateFactory() {
        EqualsVerifier.forClass(LikeDimFilter.LikeMatcher.PatternDruidPredicateFactory.class).withNonnullFields(new String[]{"pattern"}).usingGetClass().verify();
    }

    @Test
    public void test_LikeMatcher_equals() {
        EqualsVerifier.forClass(LikeDimFilter.LikeMatcher.class).usingGetClass().withNonnullFields(new String[]{"suffixMatch", "prefix", "pattern"}).verify();
    }
}

