/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByQueryEngineV2Test {
    private static final String DIM = "d0";
    ColumnSelectorFactory factory;

    @Before
    public void setUp() {
        this.factory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
    }

    @Test
    public void testCanPushDownLimitForSegmentStringSelector() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ValueType.STRING).setHasBitmapIndexes(true).setHasMultipleValues(false).setDictionaryEncoded(true).setDictionaryValuesSorted(true).setDictionaryValuesUnique(true);
        EasyMock.expect((Object)this.factory.getColumnCapabilities(DIM)).andReturn((Object)capabilities).once();
        EasyMock.replay((Object[])new Object[]{this.factory});
        Assert.assertTrue((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        EasyMock.verify((Object[])new Object[]{this.factory});
    }

    @Test
    public void testCanPushDownLimitForIncrementalStringSelector() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ValueType.STRING).setHasBitmapIndexes(false).setHasMultipleValues(false).setDictionaryEncoded(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(true);
        EasyMock.expect((Object)this.factory.getColumnCapabilities(DIM)).andReturn((Object)capabilities).once();
        EasyMock.replay((Object[])new Object[]{this.factory});
        Assert.assertFalse((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        EasyMock.verify((Object[])new Object[]{this.factory});
    }

    @Test
    public void testCanPushDownLimitForExpressionStringSelector() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ValueType.STRING).setHasBitmapIndexes(false).setHasMultipleValues(false).setDictionaryEncoded(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false);
        EasyMock.expect((Object)this.factory.getColumnCapabilities(DIM)).andReturn((Object)capabilities).once();
        EasyMock.replay((Object[])new Object[]{this.factory});
        Assert.assertFalse((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        EasyMock.verify((Object[])new Object[]{this.factory});
    }

    @Test
    public void testCanPushDownLimitForJoinStringSelector() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ValueType.STRING).setHasBitmapIndexes(false).setHasMultipleValues(false).setDictionaryEncoded(true).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false);
        EasyMock.expect((Object)this.factory.getColumnCapabilities(DIM)).andReturn((Object)capabilities).once();
        EasyMock.replay((Object[])new Object[]{this.factory});
        Assert.assertFalse((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        EasyMock.verify((Object[])new Object[]{this.factory});
    }

    @Test
    public void testCanPushDownLimitForNumericSelector() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ValueType.LONG).setHasBitmapIndexes(false).setHasMultipleValues(false).setDictionaryEncoded(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false);
        EasyMock.expect((Object)this.factory.getColumnCapabilities(DIM)).andReturn((Object)capabilities).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.factory});
        Assert.assertTrue((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        capabilities.setType(ValueType.DOUBLE);
        Assert.assertTrue((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        capabilities.setType(ValueType.FLOAT);
        Assert.assertTrue((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        EasyMock.verify((Object[])new Object[]{this.factory});
    }

    @Test
    public void testCanPushDownLimitForComplexSelector() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ValueType.COMPLEX).setHasBitmapIndexes(false).setHasMultipleValues(false).setDictionaryEncoded(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false);
        EasyMock.expect((Object)this.factory.getColumnCapabilities(DIM)).andReturn((Object)capabilities).once();
        EasyMock.replay((Object[])new Object[]{this.factory});
        Assert.assertTrue((boolean)GroupByQueryEngineV2.canPushDownLimit((ColumnSelectorFactory)this.factory, (String)DIM));
        EasyMock.verify((Object[])new Object[]{this.factory});
    }
}

