/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.ConcurrentGrouperTest;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.ParallelCombiner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class ParallelCombinerTest {
    private static final int THREAD_NUM = 8;
    private static final ExecutorService SERVICE = Execs.multiThreaded((int)8, (String)"parallel-combiner-test-%d");
    private static final ConcurrentGrouperTest.TestResourceHolder TEST_RESOURCE_HOLDER = new ConcurrentGrouperTest.TestResourceHolder(512);
    private static final Grouper.KeySerdeFactory<Long> KEY_SERDE_FACTORY = new ConcurrentGrouperTest.TestKeySerdeFactory();

    @AfterClass
    public static void teardown() {
        SERVICE.shutdownNow();
    }

    @Test
    public void testCombine() throws IOException {
        ParallelCombiner combiner = new ParallelCombiner((ReferenceCountingResourceHolder)TEST_RESOURCE_HOLDER, new AggregatorFactory[]{new CountAggregatorFactory("cnt").getCombiningFactory()}, KEY_SERDE_FACTORY, MoreExecutors.listeningDecorator((ExecutorService)SERVICE), false, 8, 0, 0L, 4);
        int numRows = 1000;
        ArrayList<Grouper.Entry> baseIterator = new ArrayList<Grouper.Entry>(1000);
        for (long i = 0L; i < 1000L; ++i) {
            baseIterator.add(new Grouper.Entry((Object)i, new Object[]{i * 10L}));
        }
        int leafNum = 8;
        ArrayList<TestIterator> iterators = new ArrayList<TestIterator>(8);
        for (int i = 0; i < 8; ++i) {
            iterators.add(new TestIterator(baseIterator.iterator()));
        }
        try (CloseableIterator iterator = combiner.combine(iterators, new ArrayList());){
            long expectedKey = 0L;
            while (iterator.hasNext()) {
                Assert.assertEquals((Object)new Grouper.Entry((Object)expectedKey, new Object[]{expectedKey++ * 8L * 10L}), (Object)iterator.next());
            }
        }
        iterators.forEach(it -> Assert.assertTrue((boolean)it.isClosed()));
    }

    private static final class TestIterator
    implements CloseableIterator<Grouper.Entry<Long>> {
        private final Iterator<Grouper.Entry<Long>> innerIterator;
        private boolean closed;

        TestIterator(Iterator<Grouper.Entry<Long>> innerIterator) {
            this.innerIterator = innerIterator;
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public Grouper.Entry<Long> next() {
            return this.innerIterator.next();
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
            }
        }
    }
}

