/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.scan.ScanQueryTestHelper;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class ScanQueryRunnerFactoryTest {
    private static final ScanQueryConfig CONFIG = new ScanQueryConfig(){

        public int getMaxRowsQueuedForOrdering() {
            return 10000;
        }

        public int getMaxSegmentPartitionsOrderedInMemory() {
            return 4;
        }
    };
    private static final ScanQueryRunnerFactory FACTORY = new ScanQueryRunnerFactory(new ScanQueryQueryToolChest(CONFIG, DefaultGenericQueryMetricsFactory.instance()), new ScanQueryEngine(), CONFIG);

    public static class ScanQueryRunnerFactoryNonParameterizedTest {
        private SegmentDescriptor descriptor = new SegmentDescriptor(new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1)), "1", 0);
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Test
        public void testGetValidIntervalsFromSpec() {
            MultipleSpecificSegmentSpec multiSpecificSpec = new MultipleSpecificSegmentSpec(Collections.singletonList(this.descriptor));
            SpecificSegmentSpec singleSpecificSpec = new SpecificSegmentSpec(this.descriptor);
            List intervals = FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)multiSpecificSpec);
            Assert.assertEquals((long)1L, (long)intervals.size());
            Assert.assertEquals((Object)this.descriptor.getInterval(), intervals.get(0));
            intervals = FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)singleSpecificSpec);
            Assert.assertEquals((long)1L, (long)intervals.size());
            Assert.assertEquals((Object)this.descriptor.getInterval(), intervals.get(0));
        }

        @Test(expected=UOE.class)
        public void testGetSegmentDescriptorsFromInvalidIntervalSpec() {
            MultipleIntervalSegmentSpec multiIntervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1))));
            FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)multiIntervalSpec);
        }

        @Test(expected=UOE.class)
        public void testGetSegmentDescriptorsFromInvalidLegacySpec() {
            LegacySegmentSpec legacySpec = new LegacySegmentSpec((Object)new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1)));
            FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)legacySpec);
        }

        @Test
        public void testMergeRunnersGuardrailsExceeded() {
            QueryRunner runner = FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)IntStream.range(0, CONFIG.getMaxSegmentPartitionsOrderedInMemory() + 1).mapToObj(i -> (queryPlus, responseContext) -> Sequences.empty()).collect(Collectors.toList()));
            this.expectedException.expect(ResourceLimitExceededException.class);
            this.expectedException.expectMessage("Time ordering is not supported for a Scan query with 5 segments per time chunk and a row limit of 10,001. Try reducing your query limit below maxRowsQueuedForOrdering (currently 10,000), or using compaction to reduce the number of segments per time chunk, or raising maxSegmentPartitionsOrderedInMemory (currently 4) above the number of segments you have per time chunk.");
            runner.run(QueryPlus.wrap((Query)Druids.newScanQueryBuilder().dataSource("foo").limit((long)(CONFIG.getMaxRowsQueuedForOrdering() + 1)).intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec(IntStream.range(0, CONFIG.getMaxSegmentPartitionsOrderedInMemory() + 1).mapToObj(i -> new SegmentDescriptor(Intervals.ETERNITY, "v0", i)).collect(Collectors.toList()))).order(ScanQuery.Order.ASCENDING).build()), ResponseContext.createEmpty());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ScanQueryRunnerFactoryParameterizedTest {
        private int numElements;
        private ScanQuery query;
        private ScanQuery.ResultFormat resultFormat;

        public ScanQueryRunnerFactoryParameterizedTest(int numElements, int batchSize, long limit, ScanQuery.ResultFormat resultFormat, ScanQuery.Order order) {
            this.numElements = numElements;
            this.query = Druids.newScanQueryBuilder().batchSize(batchSize).limit(limit).order(order).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dataSource("some datasource").resultFormat(resultFormat).build();
            this.resultFormat = resultFormat;
        }

        @Parameterized.Parameters(name="{0} {1} {2} {3} {4}")
        public static Iterable<Object[]> constructorFeeder() {
            ImmutableList numsElements = ImmutableList.of((Object)0, (Object)10, (Object)100);
            ImmutableList batchSizes = ImmutableList.of((Object)1, (Object)100);
            ImmutableList limits = ImmutableList.of((Object)3L, (Object)1000L, (Object)Long.MAX_VALUE);
            ImmutableList resultFormats = ImmutableList.of((Object)ScanQuery.ResultFormat.RESULT_FORMAT_LIST, (Object)ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST);
            ImmutableList order = ImmutableList.of((Object)ScanQuery.Order.ASCENDING, (Object)ScanQuery.Order.DESCENDING);
            return QueryRunnerTestHelper.cartesian(new Iterable[]{numsElements, batchSizes, limits, resultFormats, order});
        }

        @Test
        public void testSortAndLimitScanResultValues() throws IOException {
            block4: {
                ArrayList<ScanResultValue> srvs = new ArrayList<ScanResultValue>(this.numElements);
                ArrayList<Long> expectedEventTimestamps = new ArrayList<Long>();
                for (int i = 0; i < this.numElements; ++i) {
                    long timestamp = DateTimes.of((String)"2015-01-01").plusHours(i).getMillis();
                    expectedEventTimestamps.add(timestamp);
                    srvs.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
                }
                expectedEventTimestamps.sort((o1, o2) -> {
                    int retVal = 0;
                    if (o1 > o2) {
                        retVal = 1;
                    } else if (o1 < o2) {
                        retVal = -1;
                    }
                    if (this.query.getOrder().equals((Object)ScanQuery.Order.DESCENDING)) {
                        return retVal * -1;
                    }
                    return retVal;
                });
                Sequence inputSequence = Sequences.simple(srvs);
                try {
                    List output = FACTORY.stableLimitingSort(inputSequence, this.query, (List)ImmutableList.of((Object)new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1)))).toList();
                    if (this.query.getScanRowsLimit() > Integer.MAX_VALUE) {
                        Assert.fail((String)"Unsupported exception should have been thrown due to high limit");
                    }
                    this.validateSortedOutput(output, expectedEventTimestamps);
                }
                catch (UOE e) {
                    if (this.query.getScanRowsLimit() > Integer.MAX_VALUE) break block4;
                    Assert.fail((String)"Unsupported operation exception should not have been thrown here");
                }
            }
        }

        @Test
        public void testNWayMerge() {
            ArrayList<Long> expectedEventTimestamps = new ArrayList<Long>(this.numElements * 3);
            ArrayList<ScanResultValue> scanResultValues1 = new ArrayList<ScanResultValue>(this.numElements);
            for (int i = 0; i < this.numElements; ++i) {
                long timestamp = DateTimes.of((String)"2015-01-01").plusMinutes(i * 2).getMillis();
                expectedEventTimestamps.add(timestamp);
                scanResultValues1.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
            }
            ArrayList<ScanResultValue> scanResultValues2 = new ArrayList<ScanResultValue>(this.numElements);
            for (int i = 0; i < this.numElements; ++i) {
                long timestamp = DateTimes.of((String)"2015-01-01").plusMinutes(i * 2 + 1).getMillis();
                expectedEventTimestamps.add(timestamp);
                scanResultValues2.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
            }
            ArrayList<ScanResultValue> scanResultValues3 = new ArrayList<ScanResultValue>(this.numElements);
            for (int i = 0; i < this.numElements; ++i) {
                long timestamp = DateTimes.of((String)"2015-01-02").plusMinutes(i).getMillis();
                expectedEventTimestamps.add(timestamp);
                scanResultValues3.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
            }
            if (this.query.getOrder() == ScanQuery.Order.DESCENDING) {
                Collections.reverse(scanResultValues1);
                Collections.reverse(scanResultValues2);
                Collections.reverse(scanResultValues3);
            }
            QueryRunner runnerSegment1Partition1 = (queryPlus, responseContext) -> Sequences.simple((Iterable)scanResultValues1);
            QueryRunner runnerSegment1Partition2 = (queryPlus, responseContext) -> Sequences.simple((Iterable)scanResultValues2);
            QueryRunner runnerSegment2Partition1 = (queryPlus, responseContext) -> Sequences.simple((Iterable)scanResultValues3);
            QueryRunner runnerSegment2Partition2 = (queryPlus, responseContext) -> Sequences.empty();
            ArrayList<List<QueryRunner>> groupedRunners = new ArrayList<List<QueryRunner>>(2);
            if (this.query.getOrder() == ScanQuery.Order.DESCENDING) {
                groupedRunners.add(Arrays.asList(runnerSegment2Partition1, runnerSegment2Partition2));
                groupedRunners.add(Arrays.asList(runnerSegment1Partition1, runnerSegment1Partition2));
            } else {
                groupedRunners.add(Arrays.asList(runnerSegment1Partition1, runnerSegment1Partition2));
                groupedRunners.add(Arrays.asList(runnerSegment2Partition1, runnerSegment2Partition2));
            }
            expectedEventTimestamps.sort((o1, o2) -> {
                int retVal = 0;
                if (o1 > o2) {
                    retVal = 1;
                } else if (o1 < o2) {
                    retVal = -1;
                }
                if (this.query.getOrder().equals((Object)ScanQuery.Order.DESCENDING)) {
                    return retVal * -1;
                }
                return retVal;
            });
            List output = FACTORY.nWayMergeAndLimit(groupedRunners, QueryPlus.wrap((Query)this.query), ResponseContext.createEmpty()).toList();
            this.validateSortedOutput(output, expectedEventTimestamps);
        }

        private void validateSortedOutput(List<ScanResultValue> output, List<Long> expectedEventTimestamps) {
            int i;
            for (ScanResultValue srv : output) {
                if (this.resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)) {
                    Assert.assertTrue((ScanQueryTestHelper.getEventsCompactedListResultFormat(srv).size() == 1 ? 1 : 0) != 0);
                    continue;
                }
                if (!this.resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_LIST)) continue;
                Assert.assertTrue((ScanQueryTestHelper.getEventsListResultFormat(srv).size() == 1 ? 1 : 0) != 0);
            }
            Assert.assertTrue(((long)output.size() <= this.query.getScanRowsLimit() ? 1 : 0) != 0);
            for (i = 1; i < output.size(); ++i) {
                if (this.query.getOrder().equals((Object)ScanQuery.Order.DESCENDING)) {
                    Assert.assertTrue((output.get(i).getFirstEventTimestamp(this.resultFormat) < output.get(i - 1).getFirstEventTimestamp(this.resultFormat) ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((output.get(i).getFirstEventTimestamp(this.resultFormat) > output.get(i - 1).getFirstEventTimestamp(this.resultFormat) ? 1 : 0) != 0);
            }
            for (i = 0; (long)i < this.query.getScanRowsLimit() && i < output.size(); ++i) {
                Assert.assertEquals((long)expectedEventTimestamps.get(i), (long)output.get(i).getFirstEventTimestamp(this.resultFormat));
            }
        }
    }
}

