/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Druids;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ScanQueryTest {
    private static QuerySegmentSpec intervalSpec;
    private static ScanResultValue s1;
    private static ScanResultValue s2;
    private static ScanResultValue s3;

    @BeforeClass
    public static void setup() {
        intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(new Interval((ReadableInstant)DateTimes.of((String)"2012-01-01"), (ReadableInstant)DateTimes.of((String)"2012-01-01").plusHours(1))));
        ArrayList events1 = new ArrayList();
        HashMap<String, Long> event1 = new HashMap<String, Long>();
        event1.put("__time", new Long(42L));
        events1.add(event1);
        s1 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events1);
        ArrayList events2 = new ArrayList();
        HashMap<String, Long> event2 = new HashMap<String, Long>();
        event2.put("__time", new Long(43L));
        events2.add(event2);
        s2 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events2);
        ArrayList events3 = new ArrayList();
        HashMap<String, String> event3 = new HashMap<String, String>();
        event3.put("yah", "yeet");
        events3.add(event3);
        s3 = new ScanResultValue("segmentId", Collections.singletonList("yah"), events3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAscendingScanQueryWithInvalidColumns() {
        Druids.newScanQueryBuilder().order(ScanQuery.Order.ASCENDING).columns((List)ImmutableList.of((Object)"not time", (Object)"also not time")).dataSource("source").intervals(intervalSpec).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDescendingScanQueryWithInvalidColumns() {
        Druids.newScanQueryBuilder().order(ScanQuery.Order.DESCENDING).columns((List)ImmutableList.of((Object)"not time", (Object)"also not time")).dataSource("source").intervals(intervalSpec).build();
    }

    @Test
    public void testValidScanQueryInitialization() {
        List<ScanQuery.Order> nonOrderedOrders = Arrays.asList(null, ScanQuery.Order.NONE);
        for (ScanQuery.Order order : nonOrderedOrders) {
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of((Object)"not time")).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of()).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of((Object)"__time")).dataSource("source").intervals(intervalSpec).build();
        }
        ImmutableSet orderedOrders = ImmutableSet.of((Object)ScanQuery.Order.ASCENDING, (Object)ScanQuery.Order.DESCENDING);
        for (ScanQuery.Order order : orderedOrders) {
            Druids.newScanQueryBuilder().order(order).columns((List)null).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of()).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of((Object)"__time", (Object)"col2")).dataSource("source").intervals(intervalSpec).build();
        }
    }

    @Test
    public void testMergeSequenceForResults() {
        ScanQuery noOrderScan = Druids.newScanQueryBuilder().order(ScanQuery.Order.NONE).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanQuery descendingOrderScan = Druids.newScanQueryBuilder().order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanQuery ascendingOrderScan = Druids.newScanQueryBuilder().order(ScanQuery.Order.ASCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Sequence noOrderSeq = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1, (Object)s3)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2)))).flatMerge(seq -> seq, noOrderScan.getResultOrdering());
        List noOrderList = noOrderSeq.toList();
        Assert.assertEquals((long)3L, (long)noOrderList.size());
        Sequence ascendingOrderSeq = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2)))).flatMerge(seq -> seq, ascendingOrderScan.getResultOrdering());
        List ascendingList = ascendingOrderSeq.toList();
        Assert.assertEquals((long)2L, (long)ascendingList.size());
        Assert.assertEquals((Object)s1, ascendingList.get(0));
        Assert.assertEquals((Object)s2, ascendingList.get(1));
        Sequence descendingOrderSeq = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2)))).flatMerge(seq -> seq, descendingOrderScan.getResultOrdering());
        List descendingList = descendingOrderSeq.toList();
        Assert.assertEquals((long)2L, (long)descendingList.size());
        Assert.assertEquals((Object)s2, descendingList.get(0));
        Assert.assertEquals((Object)s1, descendingList.get(1));
    }

    @Test(expected=ISE.class)
    public void testTimeOrderingWithoutTimeColumn() {
        ScanQuery descendingOrderScan = Druids.newScanQueryBuilder().order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Sequence borkedSequence = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2, (Object)s3)))).flatMerge(seq -> seq, descendingOrderScan.getResultOrdering());
        List res = borkedSequence.toList();
    }

    @Test
    public void testGetRequiredColumnsWithNoColumns() {
        ScanQuery query = Druids.newScanQueryBuilder().order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Assert.assertNull((Object)query.getRequiredColumns());
    }

    @Test
    public void testGetRequiredColumnsWithEmptyColumns() {
        ScanQuery query = Druids.newScanQueryBuilder().order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).columns(Collections.emptyList()).build();
        Assert.assertNull((Object)query.getRequiredColumns());
    }

    @Test
    public void testGetRequiredColumnsWithColumns() {
        ScanQuery query = Druids.newScanQueryBuilder().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).columns(new String[]{"foo", "bar"}).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"foo", (Object)"bar"), (Object)query.getRequiredColumns());
    }
}

