/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.search.FragmentSearchQuerySpec;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.junit.Assert;
import org.junit.Test;

public class SearchQueryQueryToolChestTest {
    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = new SearchQueryQueryToolChest(null, null).getCacheStrategy(new SearchQuery((DataSource)new TableDataSource("dummy"), null, Granularities.ALL, 1, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), (List)ImmutableList.of((Object)Druids.DIMENSION_IDENTITY.apply((Object)"dim1")), (SearchQuerySpec)new FragmentSearchQuerySpec((List)ImmutableList.of((Object)"a", (Object)"b")), null, null));
        Result result = new Result(DateTimes.utc((long)123L), (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("dim1", "a"))));
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }
}

