/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.timeline.LogicalSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class TimeBoundaryQueryQueryToolChestTest {
    private static final TimeBoundaryQuery TIME_BOUNDARY_QUERY = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
    private static final TimeBoundaryQuery MAXTIME_BOUNDARY_QUERY = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, "maxTime", null, null);
    private static final TimeBoundaryQuery MINTIME_BOUNDARY_QUERY = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, "minTime", null, null);
    private static final TimeBoundaryQuery FILTERED_BOUNDARY_QUERY = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").filters("foo", "bar").build();

    private static LogicalSegment createLogicalSegment(Interval interval) {
        return TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(interval, interval);
    }

    private static LogicalSegment createLogicalSegment(final Interval interval, final Interval trueInterval) {
        return new LogicalSegment(){

            public Interval getInterval() {
                return interval;
            }

            public Interval getTrueInterval() {
                return trueInterval;
            }
        };
    }

    @Test
    public void testFilterSegments() {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(TIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)6L, (long)segments.size());
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D")));
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)segments.get(i)).getInterval(), (Object)expected.get(i).getInterval());
        }
    }

    @Test
    public void testFilterOverlapingSegments() {
        List actual = new TimeBoundaryQueryQueryToolChest().filterSegments(TIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2015/2016-08-01")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2016-08-01/2017")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017/2017-08-01"), Intervals.of((String)"2017/2018")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-01/2017-08-02")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-02/2018"), Intervals.of((String)"2017/2018"))));
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2015/2016-08-01")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017/2017-08-01"), Intervals.of((String)"2017/2018")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-01/2017-08-02")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-02/2018"), Intervals.of((String)"2017/2018")));
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < actual.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i).getInterval(), (Object)((LogicalSegment)actual.get(i)).getInterval());
            Assert.assertEquals((Object)expected.get(i).getTrueInterval(), (Object)((LogicalSegment)actual.get(i)).getTrueInterval());
        }
    }

    @Test
    public void testMaxTimeFilterSegments() {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(MAXTIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)3L, (long)segments.size());
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D")));
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)segments.get(i)).getInterval(), (Object)expected.get(i).getInterval());
        }
    }

    @Test
    public void testMaxTimeFilterOverlapingSegments() {
        List actual = new TimeBoundaryQueryQueryToolChest().filterSegments(MAXTIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2015/2016-08-01")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2016-08-01/2017")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017/2017-08-01"), Intervals.of((String)"2017/2018")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-01/2017-08-02")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-02/2018"), Intervals.of((String)"2017/2018"))));
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017/2017-08-01"), Intervals.of((String)"2017/2018")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-01/2017-08-02")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-02/2018"), Intervals.of((String)"2017/2018")));
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < actual.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i).getInterval(), (Object)((LogicalSegment)actual.get(i)).getInterval());
            Assert.assertEquals((Object)expected.get(i).getTrueInterval(), (Object)((LogicalSegment)actual.get(i)).getTrueInterval());
        }
    }

    @Test
    public void testMinTimeFilterOverlapingSegments() {
        List actual = new TimeBoundaryQueryQueryToolChest().filterSegments(MINTIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017/2017-08-01"), Intervals.of((String)"2017/2018")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-01/2017-08-02")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-02/2018"), Intervals.of((String)"2017/2018")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2018/2018-08-01")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2018-08-01/2019"))));
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017/2017-08-01"), Intervals.of((String)"2017/2018")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-01/2017-08-02")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2017-08-02/2018"), Intervals.of((String)"2017/2018")));
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < actual.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i).getInterval(), (Object)((LogicalSegment)actual.get(i)).getInterval());
            Assert.assertEquals((Object)expected.get(i).getTrueInterval(), (Object)((LogicalSegment)actual.get(i)).getTrueInterval());
        }
    }

    @Test
    public void testMinTimeFilterSegments() {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(MINTIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)3L, (long)segments.size());
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")));
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)segments.get(i)).getInterval(), (Object)expected.get(i).getInterval());
        }
    }

    @Test
    public void testFilteredFilterSegments() {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(FILTERED_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)7L, (long)segments.size());
    }

    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = new TimeBoundaryQueryQueryToolChest().getCacheStrategy(new TimeBoundaryQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, null, null));
        Result result = new Result(DateTimes.utc((long)123L), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.EPOCH.toString(), (Object)"maxTime", (Object)DateTimes.of((String)"2015-01-01").toString())));
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }
}

