/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.TestQueryRunners;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.LegacyTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TopNQueryQueryToolChestTest
extends InitializedNullHandlingTest {
    private static final SegmentId SEGMENT_ID = SegmentId.dummy((String)"testSegment");

    @BeforeClass
    public static void setUpClass() {
        NullHandling.initializeForTests();
    }

    @Test
    public void testCacheStrategy() throws Exception {
        this.doTestCacheStrategy(ValueType.STRING, "val1");
        this.doTestCacheStrategy(ValueType.FLOAT, Float.valueOf(2.1f));
        this.doTestCacheStrategy(ValueType.DOUBLE, 2.1);
        this.doTestCacheStrategy(ValueType.LONG, 2L);
    }

    @Test
    public void testCacheStrategyOrderByPostAggs() throws Exception {
        this.doTestCacheStrategyOrderByPost(ValueType.STRING, "val1");
        this.doTestCacheStrategyOrderByPost(ValueType.FLOAT, Float.valueOf(2.1f));
        this.doTestCacheStrategyOrderByPost(ValueType.DOUBLE, 2.1);
        this.doTestCacheStrategyOrderByPost(ValueType.LONG, 2L);
    }

    @Test
    public void testComputeCacheKeyWithDifferentPostAgg() {
        TopNQuery query1 = new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test"), (TopNMetricSpec)new NumericTopNMetricSpec("post"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1")), (List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10)), null);
        TopNQuery query2 = new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test"), (TopNMetricSpec)new NumericTopNMetricSpec("post"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1")), (List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "+", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric1")))), null);
        CacheStrategy strategy1 = new TopNQueryQueryToolChest(null, null).getCacheStrategy(query1);
        CacheStrategy strategy2 = new TopNQueryQueryToolChest(null, null).getCacheStrategy(query2);
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testComputeResultLevelCacheKeyWithDifferentPostAgg() {
        TopNQuery query1 = new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test"), (TopNMetricSpec)new LegacyTopNMetricSpec((Object)"metric1"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01T18:00:00/2015-01-02T18:00:00"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric1", "metric1"), (Object)new LongSumAggregatorFactory("metric2", "metric2")), (List)ImmutableList.of((Object)new ArithmeticPostAggregator("post1", "/", (List)ImmutableList.of((Object)new FieldAccessPostAggregator("metric1", "metric1"), (Object)new FieldAccessPostAggregator("metric2", "metric2")))), null);
        TopNQuery query2 = new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test"), (TopNMetricSpec)new LegacyTopNMetricSpec((Object)"metric1"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01T18:00:00/2015-01-02T18:00:00"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric1", "metric1"), (Object)new LongSumAggregatorFactory("metric2", "metric2")), (List)ImmutableList.of((Object)new ArithmeticPostAggregator("post2", "+", (List)ImmutableList.of((Object)new FieldAccessPostAggregator("metric1", "metric1"), (Object)new FieldAccessPostAggregator("metric2", "metric2")))), null);
        CacheStrategy strategy1 = new TopNQueryQueryToolChest(null, null).getCacheStrategy(query1);
        CacheStrategy strategy2 = new TopNQueryQueryToolChest(null, null).getCacheStrategy(query2);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy1.computeResultLevelCacheKey((Query)query1)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testMinTopNThreshold() {
        TopNQueryConfig config = new TopNQueryConfig();
        TopNQueryQueryToolChest chest = new TopNQueryQueryToolChest(config);
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, chest, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SEGMENT_ID), null);
            HashMap<String, Integer> context = new HashMap<String, Integer>();
            context.put("minTopNThreshold", 500);
            TopNQueryBuilder builder = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("placementish").metric("index").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS);
            TopNQuery query1 = builder.threshold(10).context(null).build();
            MockQueryRunner mockRunner = new MockQueryRunner(runner);
            new TopNQueryQueryToolChest.ThresholdAdjustingQueryRunner((QueryRunner)mockRunner, config).run(QueryPlus.wrap((Query)query1));
            Assert.assertEquals((long)1000L, (long)mockRunner.query.getThreshold());
            TopNQuery query2 = builder.threshold(10).context(context).build();
            new TopNQueryQueryToolChest.ThresholdAdjustingQueryRunner((QueryRunner)mockRunner, config).run(QueryPlus.wrap((Query)query2));
            Assert.assertEquals((long)500L, (long)mockRunner.query.getThreshold());
            TopNQuery query3 = builder.threshold(2000).context(context).build();
            new TopNQueryQueryToolChest.ThresholdAdjustingQueryRunner((QueryRunner)mockRunner, config).run(QueryPlus.wrap((Query)query3));
            Assert.assertEquals((long)2000L, (long)mockRunner.query.getThreshold());
        }
    }

    @Test
    public void testResultArraySignature() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("col", "dim")).metric("index").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.CONSTANT}).threshold(1).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("dim", ValueType.STRING).add("rows", ValueType.LONG).add("index", ValueType.DOUBLE).add("uniques", null).add("const", ValueType.LONG).build(), (Object)new TopNQueryQueryToolChest(null, null).resultArraySignature(query));
    }

    @Test
    public void testResultsAsArrays() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("col", "dim")).metric("index").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.CONSTANT}).threshold(1).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000").getMillis(), "foo", 1L, 2L, 3L, 1L}, (Object)new Object[]{DateTimes.of((String)"2000").getMillis(), "bar", 4L, 5L, 6L, 1L}), (Sequence<Object[]>)new TopNQueryQueryToolChest(null, null).resultsAsArrays(query, Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2000"), (Object)new TopNResultValue((List)ImmutableList.of((Object)new DimensionAndMetricValueExtractor((Map)ImmutableMap.of((Object)"dim", (Object)"foo", (Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"uniques", (Object)3L, (Object)"const", (Object)1L)), (Object)new DimensionAndMetricValueExtractor((Map)ImmutableMap.of((Object)"dim", (Object)"bar", (Object)"rows", (Object)4L, (Object)"index", (Object)5L, (Object)"uniques", (Object)6L, (Object)"const", (Object)1L)))))))));
    }

    private AggregatorFactory getComplexAggregatorFactoryForValueType(ValueType valueType) {
        switch (valueType) {
            case LONG: {
                return new LongLastAggregatorFactory("complexMetric", "test");
            }
            case DOUBLE: {
                return new DoubleLastAggregatorFactory("complexMetric", "test");
            }
            case FLOAT: {
                return new FloatLastAggregatorFactory("complexMetric", "test");
            }
            case STRING: {
                return new StringLastAggregatorFactory("complexMetric", "test", null);
            }
        }
        throw new IllegalArgumentException("bad valueType: " + valueType);
    }

    private SerializablePair getIntermediateComplexValue(ValueType valueType, Object dimValue) {
        switch (valueType) {
            case LONG: 
            case DOUBLE: 
            case FLOAT: {
                return new SerializablePair((Object)123L, dimValue);
            }
            case STRING: {
                return new SerializablePairLongString(Long.valueOf(123L), (String)dimValue);
            }
        }
        throw new IllegalArgumentException("bad valueType: " + valueType);
    }

    private HyperLogLogCollector getIntermediateHllCollector(ValueType valueType, Object dimValue) {
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        switch (valueType) {
            case LONG: {
                collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(((Long)dimValue).longValue()).asBytes());
                break;
            }
            case DOUBLE: {
                collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(Double.doubleToLongBits((Double)dimValue)).asBytes());
                break;
            }
            case FLOAT: {
                collector.add(CardinalityAggregator.HASH_FUNCTION.hashInt(Float.floatToIntBits(((Float)dimValue).floatValue())).asBytes());
                break;
            }
            case STRING: {
                collector.add(CardinalityAggregator.HASH_FUNCTION.hashUnencodedChars((CharSequence)((String)dimValue)).asBytes());
                break;
            }
            default: {
                throw new IllegalArgumentException("bad valueType: " + valueType);
            }
        }
        return collector;
    }

    private void doTestCacheStrategy(ValueType valueType, Object dimValue) throws IOException {
        CacheStrategy strategy = new TopNQueryQueryToolChest(null, null).getCacheStrategy(new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test", valueType), (TopNMetricSpec)new NumericTopNMetricSpec("metric1"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1"), (Object)this.getComplexAggregatorFactoryForValueType(valueType)), (List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10)), null));
        Result result1 = new Result(DateTimes.utc((long)123L), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.of((Object)"test", (Object)dimValue, (Object)"metric1", (Object)2, (Object)"complexMetric", (Object)this.getIntermediateComplexValue(valueType, dimValue)))));
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
        Result result2 = new Result(DateTimes.utc((long)123L), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.of((Object)"test", (Object)dimValue, (Object)"metric1", (Object)2, (Object)"complexMetric", (Object)dimValue, (Object)"post", (Object)10))));
        Result typeAdjustedResult2 = valueType == ValueType.FLOAT ? new Result(DateTimes.utc((long)123L), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.of((Object)"test", (Object)dimValue, (Object)"metric1", (Object)2, (Object)"complexMetric", (Object)2.1, (Object)"post", (Object)10)))) : (valueType == ValueType.LONG ? new Result(DateTimes.utc((long)123L), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.of((Object)"test", (Object)dimValue, (Object)"metric1", (Object)2, (Object)"complexMetric", (Object)2, (Object)"post", (Object)10)))) : result2);
        Object preparedResultCacheValue = strategy.prepareForCache(true).apply((Object)result2);
        Object fromResultCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultCacheValue), strategy.getCacheObjectClazz());
        Result fromResultCacheResult = (Result)strategy.pullFromCache(true).apply(fromResultCacheValue);
        Assert.assertEquals((Object)typeAdjustedResult2, (Object)fromResultCacheResult);
    }

    private void doTestCacheStrategyOrderByPost(ValueType valueType, Object dimValue) throws IOException {
        CacheStrategy strategy = new TopNQueryQueryToolChest(null, null).getCacheStrategy(new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test", valueType), (TopNMetricSpec)new NumericTopNMetricSpec("post"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new HyperUniquesAggregatorFactory("metric1", "test", false, false), (Object)new CountAggregatorFactory("metric2")), (List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "+", (List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("metric1", "metric1"), (Object)new FieldAccessPostAggregator("metric2", "metric2")))), null));
        HyperLogLogCollector collector = this.getIntermediateHllCollector(valueType, dimValue);
        Result result1 = new Result(DateTimes.utc((long)123L), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.of((Object)"test", (Object)dimValue, (Object)"metric1", (Object)collector, (Object)"metric2", (Object)2, (Object)"post", (Object)(collector.estimateCardinality() + 2.0)))));
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
        Result resultLevelCacheResult = new Result(DateTimes.utc((long)123L), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.of((Object)"test", (Object)dimValue, (Object)"metric1", (Object)collector.estimateCardinality(), (Object)"metric2", (Object)2, (Object)"post", (Object)(collector.estimateCardinality() + 2.0)))));
        Object preparedResultCacheValue = strategy.prepareForCache(true).apply((Object)resultLevelCacheResult);
        Object fromResultCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultCacheValue), strategy.getCacheObjectClazz());
        Result fromResultCacheResult = (Result)strategy.pullFromCache(true).apply(fromResultCacheValue);
        Assert.assertEquals((Object)resultLevelCacheResult, (Object)fromResultCacheResult);
    }

    static class MockQueryRunner
    implements QueryRunner<Result<TopNResultValue>> {
        private final QueryRunner<Result<TopNResultValue>> runner;
        TopNQuery query = null;

        MockQueryRunner(QueryRunner<Result<TopNResultValue>> runner) {
            this.runner = runner;
        }

        public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, ResponseContext responseContext) {
            this.query = (TopNQuery)queryPlus.getQuery();
            return this.runner.run(queryPlus, responseContext);
        }
    }
}

