/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.junit.Assert;
import org.junit.Test;

public class DictionaryMergeIteratorTest {
    @Test
    public void basicTest() {
        Object[] s1 = new String[]{"a", "c", "d", "e"};
        Object[] s2 = new String[]{"b", "c", "e"};
        Object[] s3 = new String[]{"a", "d", "f"};
        Object[] s4 = new String[]{"a", "b", "c"};
        Object[] s5 = new String[]{"a", "b", "c", "d", "e", "f"};
        ListIndexed i1 = new ListIndexed(s1);
        ListIndexed i2 = new ListIndexed(s2);
        ListIndexed i3 = new ListIndexed(s3);
        ListIndexed i4 = new ListIndexed(s4);
        ListIndexed i5 = new ListIndexed(s5);
        IndexMerger.DictionaryMergeIterator iterator = new IndexMerger.DictionaryMergeIterator(new Indexed[]{i1, i2, i3, i4, i5}, false);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (Object[])Iterators.toArray((Iterator)iterator, String.class));
        Assert.assertArrayEquals((int[])new int[]{0, 2, 3, 4}, (int[])iterator.conversions[0].array());
        Assert.assertArrayEquals((int[])new int[]{1, 2, 4}, (int[])iterator.conversions[1].array());
        Assert.assertArrayEquals((int[])new int[]{0, 3, 5}, (int[])iterator.conversions[2].array());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])iterator.conversions[3].array());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5}, (int[])iterator.conversions[4].array());
        Assert.assertTrue((boolean)iterator.needConversion(0));
        Assert.assertTrue((boolean)iterator.needConversion(1));
        Assert.assertTrue((boolean)iterator.needConversion(2));
        Assert.assertFalse((boolean)iterator.needConversion(3));
        Assert.assertFalse((boolean)iterator.needConversion(4));
    }
}

