/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.SegmentId;

public class IndexBuilder {
    private static final int ROWS_PER_INDEX_FOR_MERGING = 1;
    private static final int DEFAULT_MAX_ROWS = Integer.MAX_VALUE;
    private IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
    private SegmentWriteOutMediumFactory segmentWriteOutMediumFactory = OffHeapMemorySegmentWriteOutMediumFactory.instance();
    private IndexMerger indexMerger;
    private File tmpDir;
    private IndexSpec indexSpec = new IndexSpec();
    private int maxRows = Integer.MAX_VALUE;
    private final ObjectMapper jsonMapper;
    private final IndexIO indexIO;
    private final List<InputRow> rows = new ArrayList<InputRow>();

    private IndexBuilder(ObjectMapper jsonMapper, ColumnConfig columnConfig) {
        this.jsonMapper = jsonMapper;
        this.indexIO = new IndexIO(jsonMapper, columnConfig);
        this.indexMerger = new IndexMergerV9(jsonMapper, this.indexIO, this.segmentWriteOutMediumFactory);
    }

    public static IndexBuilder create() {
        return new IndexBuilder(TestHelper.JSON_MAPPER, TestHelper.NO_CACHE_COLUMN_CONFIG);
    }

    public static IndexBuilder create(ColumnConfig columnConfig) {
        return new IndexBuilder(TestHelper.JSON_MAPPER, columnConfig);
    }

    public static IndexBuilder create(ObjectMapper jsonMapper) {
        return new IndexBuilder(jsonMapper, TestHelper.NO_CACHE_COLUMN_CONFIG);
    }

    public static IndexBuilder create(ObjectMapper jsonMapper, ColumnConfig columnConfig) {
        return new IndexBuilder(jsonMapper, columnConfig);
    }

    public IndexBuilder schema(IncrementalIndexSchema schema) {
        this.schema = schema;
        return this;
    }

    public IndexBuilder segmentWriteOutMediumFactory(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.indexMerger = new IndexMergerV9(this.jsonMapper, this.indexIO, segmentWriteOutMediumFactory);
        return this;
    }

    public IndexBuilder indexSpec(IndexSpec indexSpec) {
        this.indexSpec = indexSpec;
        return this;
    }

    public IndexBuilder tmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
        return this;
    }

    public IndexBuilder rows(Iterable<InputRow> rows) {
        this.rows.clear();
        Iterables.addAll(this.rows, rows);
        return this;
    }

    public IncrementalIndex buildIncrementalIndex() {
        return IndexBuilder.buildIncrementalIndexWithRows(this.schema, this.maxRows, this.rows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueryableIndex buildMMappedIndex() {
        Preconditions.checkNotNull((Object)this.indexMerger, (Object)"indexMerger");
        Preconditions.checkNotNull((Object)this.tmpDir, (Object)"tmpDir");
        try (IncrementalIndex incrementalIndex = this.buildIncrementalIndex();){
            QueryableIndex queryableIndex = this.indexIO.loadIndex(this.indexMerger.persist(incrementalIndex, new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE)})), this.indexSpec, null));
            return queryableIndex;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public QueryableIndex buildMMappedMergedIndex() {
        IndexMergerV9 indexMerger = TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory);
        Preconditions.checkNotNull((Object)this.tmpDir, (Object)"tmpDir");
        ArrayList<QueryableIndex> persisted = new ArrayList<QueryableIndex>();
        try {
            for (int i = 0; i < this.rows.size(); ++i) {
                persisted.add(TestHelper.getTestIndexIO().loadIndex(indexMerger.persist(IndexBuilder.buildIncrementalIndexWithRows(this.schema, this.maxRows, this.rows.subList(i, Math.min(this.rows.size(), i + 1))), new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{UUID.randomUUID().toString()})), this.indexSpec, null)));
            }
            QueryableIndex merged = TestHelper.getTestIndexIO().loadIndex(indexMerger.merge(Lists.transform(persisted, QueryableIndexIndexableAdapter::new), true, (AggregatorFactory[])Iterables.toArray((Iterable)Iterables.transform(Arrays.asList(this.schema.getMetrics()), AggregatorFactory::getCombiningFactory), AggregatorFactory.class), new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{UUID.randomUUID()})), this.indexSpec, -1));
            for (QueryableIndex index : persisted) {
                index.close();
            }
            return merged;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RowBasedSegment<InputRow> buildRowBasedSegmentWithoutTypeSignature() {
        return new RowBasedSegment(SegmentId.dummy((String)"IndexBuilder"), this.rows, RowAdapters.standardRow(), RowSignature.empty());
    }

    public RowBasedSegment<InputRow> buildRowBasedSegmentWithTypeSignature() {
        try (QueryableIndex index = this.buildMMappedIndex();){
            RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
            for (String columnName : index.getColumnNames()) {
                ColumnCapabilities capabilities = index.getColumnHolder(columnName).getCapabilities();
                rowSignatureBuilder.add(columnName, capabilities.getType());
            }
            RowBasedSegment rowBasedSegment = new RowBasedSegment(SegmentId.dummy((String)"IndexBuilder"), this.rows, RowAdapters.standardRow(), rowSignatureBuilder.build());
            return rowBasedSegment;
        }
    }

    private static IncrementalIndex buildIncrementalIndexWithRows(IncrementalIndexSchema schema, int maxRows, Iterable<InputRow> rows) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        IncrementalIndex incrementalIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(maxRows).build();
        for (InputRow row : rows) {
            try {
                incrementalIndex.add(row);
            }
            catch (IndexSizeExceededException e) {
                throw new RuntimeException(e);
            }
        }
        return incrementalIndex;
    }
}

