/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.TestFloatColumnSelector;

public class TestNullableFloatColumnSelector
extends TestFloatColumnSelector {
    private final Float[] floats;
    private int index = 0;

    public TestNullableFloatColumnSelector(Float[] floats) {
        this.floats = floats;
    }

    public float getFloat() {
        if (this.floats[this.index] != null) {
            return this.floats[this.index].floatValue();
        }
        if (NullHandling.replaceWithDefault()) {
            return NullHandling.ZERO_FLOAT.floatValue();
        }
        throw new IllegalStateException("Should never be invoked when current value is null && SQL-compatible null handling is enabled!");
    }

    public boolean isNull() {
        return !NullHandling.replaceWithDefault() && this.floats[this.index] == null;
    }

    public void increment() {
        ++this.index;
    }

    static {
        NullHandling.initializeForTests();
    }
}

