/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import com.google.common.primitives.Floats;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarFloats;
import org.apache.druid.segment.data.ColumnarFloatsSerializer;
import org.apache.druid.segment.data.CompressedColumnarFloatsSupplier;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedFloatsSerdeTest {
    private static final double DELTA = 1.0E-5;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected final CompressionStrategy compressionStrategy;
    protected final ByteOrder order;
    private final float[] values0 = new float[0];
    private final float[] values1 = new float[]{0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
    private final float[] values2 = new float[]{13.2f, 6.1f, 0.001f, 123.0f, 12572.0f, 123.1f, 784.4f, 6892.8633f, 8.341111f};
    private final float[] values3 = new float[]{0.001f, 0.001f, 0.001f, 0.001f, 0.001f, 100.0f, 100.0f, 100.0f, 100.0f, 100.0f};
    private final float[] values4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.0f, 0.0f, 0.0f, 21.22f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] values5 = new float[]{123.16f, 1.12f, 62.0f, 462.12f, 517.71f, 56.54f, 971.32f, 824.22f, 472.12f, 625.26f};
    private final float[] values6 = new float[]{1000000.0f, 1000001.0f, 1000002.0f, 1000003.0f, 1000004.0f, 1000005.0f, 1000006.0f, 1000007.0f, 1000008.0f};
    private final float[] values7 = new float[]{Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, 12378.573f, -1.2718244E7f, -9.3653656E7f, 1.2743153E7f, 21431.414f, 6.5487434E13f, -4.3734528E13f};

    @Parameterized.Parameters(name="{0} {1} {2}")
    public static Iterable<Object[]> compressionStrategies() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (CompressionStrategy strategy : CompressionStrategy.values()) {
            data.add(new Object[]{strategy, ByteOrder.BIG_ENDIAN});
            data.add(new Object[]{strategy, ByteOrder.LITTLE_ENDIAN});
        }
        return data;
    }

    public CompressedFloatsSerdeTest(CompressionStrategy compressionStrategy, ByteOrder order) {
        this.compressionStrategy = compressionStrategy;
        this.order = order;
    }

    @Test
    public void testValueSerde() throws Exception {
        this.testWithValues(this.values0);
        this.testWithValues(this.values1);
        this.testWithValues(this.values2);
        this.testWithValues(this.values3);
        this.testWithValues(this.values4);
        this.testWithValues(this.values5);
        this.testWithValues(this.values6);
        this.testWithValues(this.values7);
    }

    @Test
    public void testChunkSerde() throws Exception {
        float[] chunk = new float[10000];
        for (int i = 0; i < 10000; ++i) {
            chunk[i] = i;
        }
        this.testWithValues(chunk);
    }

    @Ignore
    @Test
    public void testTooManyValues() throws IOException {
        this.expectedException.expect(ColumnCapacityExceededException.class);
        this.expectedException.expectMessage(ColumnCapacityExceededException.formatMessage((String)"test"));
        try (SegmentWriteOutMedium segmentWriteOutMedium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(this.temporaryFolder.newFolder());){
            ColumnarFloatsSerializer serializer = CompressionFactory.getFloatSerializer((String)"test", (SegmentWriteOutMedium)segmentWriteOutMedium, (String)"test", (ByteOrder)this.order, (CompressionStrategy)this.compressionStrategy);
            serializer.open();
            long numRows = 2147483747L;
            for (long i = 0L; i < 2147483747L; ++i) {
                serializer.add(ThreadLocalRandom.current().nextFloat());
            }
        }
    }

    public void testWithValues(float[] values) throws Exception {
        ColumnarFloatsSerializer serializer = CompressionFactory.getFloatSerializer((String)"test", (SegmentWriteOutMedium)new OffHeapMemorySegmentWriteOutMedium(), (String)"test", (ByteOrder)this.order, (CompressionStrategy)this.compressionStrategy);
        serializer.open();
        for (float value : values) {
            serializer.add(value);
        }
        Assert.assertEquals((long)values.length, (long)serializer.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.writeTo(Channels.newChannel(baos), null);
        Assert.assertEquals((long)baos.size(), (long)serializer.getSerializedSize());
        CompressedColumnarFloatsSupplier supplier = CompressedColumnarFloatsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(baos.toByteArray()), (ByteOrder)this.order);
        ColumnarFloats floats = supplier.get();
        this.assertIndexMatchesVals(floats, values);
        for (int i = 0; i < 10; ++i) {
            int b;
            int a = (int)(ThreadLocalRandom.current().nextDouble() * (double)values.length);
            int start = a < (b = (int)(ThreadLocalRandom.current().nextDouble() * (double)values.length)) ? a : b;
            int end = a < b ? b : a;
            this.tryFill(floats, values, start, end - start);
        }
        this.testSupplierSerde(supplier, values);
        this.testConcurrentThreadReads((Supplier<ColumnarFloats>)supplier, floats, values);
        floats.close();
    }

    private void tryFill(ColumnarFloats indexed, float[] vals, int startIndex, int size) {
        float[] filled = new float[size];
        indexed.get(filled, startIndex, filled.length);
        for (int i = startIndex; i < filled.length; ++i) {
            Assert.assertEquals((double)vals[i + startIndex], (double)filled[i], (double)1.0E-5);
        }
    }

    private void assertIndexMatchesVals(ColumnarFloats indexed, float[] vals) {
        Assert.assertEquals((long)vals.length, (long)indexed.size());
        int[] indices = new int[vals.length];
        for (int i = 0; i < indexed.size(); ++i) {
            Assert.assertEquals((double)vals[i], (double)indexed.get(i), (double)1.0E-5);
            indices[i] = i;
        }
        IntArrays.shuffle((int[])indices, (Random)ThreadLocalRandom.current());
        int limit = Math.min(indexed.size(), 1000);
        for (int i = 0; i < limit; ++i) {
            int k = indices[i];
            Assert.assertEquals((double)vals[k], (double)indexed.get(k), (double)1.0E-5);
        }
    }

    private void testSupplierSerde(CompressedColumnarFloatsSupplier supplier, float[] vals) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        supplier.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)supplier.getSerializedSize(), (long)bytes.length);
        CompressedColumnarFloatsSupplier anotherSupplier = CompressedColumnarFloatsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)this.order);
        ColumnarFloats indexed = anotherSupplier.get();
        this.assertIndexMatchesVals(indexed, vals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentThreadReads(Supplier<ColumnarFloats> supplier, final ColumnarFloats indexed, final float[] vals) throws Exception {
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        for (int j = 0; j < indexed.size(); ++j) {
                            float val = vals[j];
                            float indexedVal = indexed.get(j);
                            if (Floats.compare((float)val, (float)indexedVal) == 0) continue;
                            failureHappened.set(true);
                            reason.set(StringUtils.format((String)"Thread1[%d]: %f != %f", (Object[])new Object[]{j, Float.valueOf(val), Float.valueOf(indexedVal)}));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        final ColumnarFloats indexed2 = (ColumnarFloats)supplier.get();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = indexed2.size() - 1; j >= 0; --j) {
                                float val = vals[j];
                                float indexedVal = indexed2.get(j);
                                if (Floats.compare((float)val, (float)indexedVal) == 0) continue;
                                failureHappened.set(true);
                                reason.set(StringUtils.format((String)"Thread2[%d]: %f != %f", (Object[])new Object[]{j, Float.valueOf(val), Float.valueOf(indexedVal)}));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        finally {
            CloseQuietly.close((Closeable)indexed2);
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }
}

