/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import com.google.common.primitives.Longs;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedLongsSerdeTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected final CompressionFactory.LongEncodingStrategy encodingStrategy;
    protected final CompressionStrategy compressionStrategy;
    protected final ByteOrder order;
    private final long[] values0 = new long[0];
    private final long[] values1 = new long[]{0L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 1L};
    private final long[] values2 = new long[]{12L, 5L, 2L, 9L, 3L, 2L, 5L, 1L, 0L, 6L, 13L, 10L, 15L};
    private final long[] values3 = new long[]{1L, 1L, 1L, 1L, 1L, 11L, 11L, 11L, 11L};
    private final long[] values4 = new long[]{200L, 200L, 200L, 401L, 200L, 301L, 200L, 200L, 200L, 404L, 200L, 200L, 200L, 200L};
    private final long[] values5 = new long[]{123L, 632L, 12L, 39L, 536L, 0L, 1023L, 52L, 777L, 526L, 214L, 562L, 823L, 346L};
    private final long[] values6 = new long[]{1000000L, 1000001L, 1000002L, 1000003L, 1000004L, 1000005L, 1000006L, 1000007L, 1000008L};
    private final long[] values7 = new long[]{Long.MAX_VALUE, Long.MIN_VALUE, 12378L, -12718243L, -1236213L, 12743153L, 21364375452L, 65487435436632L, -43734526234564L};
    private final long[] values8 = new long[]{Long.MAX_VALUE, 0L, 321L, 15248425L, 13523212136L, 63822L, 3426L, 96L};

    @Parameterized.Parameters(name="{0} {1} {2}")
    public static Iterable<Object[]> compressionStrategies() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (CompressionFactory.LongEncodingStrategy encodingStrategy : CompressionFactory.LongEncodingStrategy.values()) {
            for (CompressionStrategy strategy : CompressionStrategy.values()) {
                data.add(new Object[]{encodingStrategy, strategy, ByteOrder.BIG_ENDIAN});
                data.add(new Object[]{encodingStrategy, strategy, ByteOrder.LITTLE_ENDIAN});
            }
        }
        return data;
    }

    private static long[] addUniques(long[] val) {
        long[] ret = new long[val.length + 256];
        for (int i = 0; i < 256; ++i) {
            ret[i] = i;
        }
        System.arraycopy(val, 0, ret, 256, val.length);
        return ret;
    }

    public CompressedLongsSerdeTest(CompressionFactory.LongEncodingStrategy encodingStrategy, CompressionStrategy compressionStrategy, ByteOrder order) {
        this.encodingStrategy = encodingStrategy;
        this.compressionStrategy = compressionStrategy;
        this.order = order;
    }

    @Test
    public void testValueSerde() throws Exception {
        this.testWithValues(this.values0);
        this.testWithValues(this.values1);
        this.testWithValues(this.values2);
        this.testWithValues(this.values3);
        this.testWithValues(this.values4);
        this.testWithValues(this.values5);
        this.testWithValues(this.values6);
        this.testWithValues(this.values7);
        this.testWithValues(this.values8);
    }

    @Test
    public void testChunkSerde() throws Exception {
        long[] chunk = new long[10000];
        for (int i = 0; i < 10000; ++i) {
            chunk[i] = i;
        }
        this.testWithValues(chunk);
    }

    @Ignore
    @Test
    public void testTooManyValues() throws IOException {
        if (this.encodingStrategy.equals((Object)CompressionFactory.LongEncodingStrategy.AUTO)) {
            return;
        }
        this.expectedException.expect(ColumnCapacityExceededException.class);
        this.expectedException.expectMessage(ColumnCapacityExceededException.formatMessage((String)"test"));
        try (SegmentWriteOutMedium segmentWriteOutMedium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(this.temporaryFolder.newFolder());){
            ColumnarLongsSerializer serializer = CompressionFactory.getLongSerializer((String)"test", (SegmentWriteOutMedium)segmentWriteOutMedium, (String)"test", (ByteOrder)this.order, (CompressionFactory.LongEncodingStrategy)this.encodingStrategy, (CompressionStrategy)this.compressionStrategy);
            serializer.open();
            long numRows = 2147483747L;
            for (long i = 0L; i < 2147483747L; ++i) {
                serializer.add(ThreadLocalRandom.current().nextLong());
            }
        }
    }

    public void testWithValues(long[] values) throws Exception {
        this.testValues(values);
        this.testValues(CompressedLongsSerdeTest.addUniques(values));
    }

    public void testValues(long[] values) throws Exception {
        ColumnarLongsSerializer serializer = CompressionFactory.getLongSerializer((String)"test", (SegmentWriteOutMedium)new OffHeapMemorySegmentWriteOutMedium(), (String)"test", (ByteOrder)this.order, (CompressionFactory.LongEncodingStrategy)this.encodingStrategy, (CompressionStrategy)this.compressionStrategy);
        serializer.open();
        for (long value : values) {
            serializer.add(value);
        }
        Assert.assertEquals((long)values.length, (long)serializer.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.writeTo(Channels.newChannel(baos), null);
        Assert.assertEquals((long)baos.size(), (long)serializer.getSerializedSize());
        CompressedColumnarLongsSupplier supplier = CompressedColumnarLongsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(baos.toByteArray()), (ByteOrder)this.order);
        ColumnarLongs longs = supplier.get();
        this.assertIndexMatchesVals(longs, values);
        for (int i = 0; i < 10; ++i) {
            int b;
            int a = (int)(ThreadLocalRandom.current().nextDouble() * (double)values.length);
            int start = a < (b = (int)(ThreadLocalRandom.current().nextDouble() * (double)values.length)) ? a : b;
            int end = a < b ? b : a;
            this.tryFill(longs, values, start, end - start);
        }
        this.testSupplierSerde(supplier, values);
        this.testConcurrentThreadReads((Supplier<ColumnarLongs>)supplier, longs, values);
        longs.close();
    }

    private void tryFill(ColumnarLongs indexed, long[] vals, int startIndex, int size) {
        long[] filled = new long[size];
        indexed.get(filled, startIndex, size);
        for (int i = startIndex; i < filled.length; ++i) {
            Assert.assertEquals((long)vals[i + startIndex], (long)filled[i]);
        }
    }

    private void assertIndexMatchesVals(ColumnarLongs indexed, long[] vals) {
        Assert.assertEquals((long)vals.length, (long)indexed.size());
        long[] vector = new long[256];
        int[] indices = new int[vals.length];
        for (int i = 0; i < indexed.size(); ++i) {
            if (i % 256 == 0) {
                indexed.get(vector, i, Math.min(256, indexed.size() - i));
            }
            Assert.assertEquals((long)vals[i], (long)indexed.get(i));
            Assert.assertEquals((long)vals[i], (long)vector[i % 256]);
            indices[i] = i;
        }
        IntArrays.shuffle((int[])indices, (Random)ThreadLocalRandom.current());
        int limit = Math.min(indexed.size(), 1000);
        for (int i = 0; i < limit; ++i) {
            int k = indices[i];
            Assert.assertEquals((long)vals[k], (long)indexed.get(k));
        }
    }

    private void testSupplierSerde(CompressedColumnarLongsSupplier supplier, long[] vals) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        supplier.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)supplier.getSerializedSize(), (long)bytes.length);
        CompressedColumnarLongsSupplier anotherSupplier = CompressedColumnarLongsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)this.order);
        ColumnarLongs indexed = anotherSupplier.get();
        this.assertIndexMatchesVals(indexed, vals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentThreadReads(Supplier<ColumnarLongs> supplier, final ColumnarLongs indexed, final long[] vals) throws Exception {
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        for (int j = 0; j < indexed.size(); ++j) {
                            long val = vals[j];
                            long indexedVal = indexed.get(j);
                            if (Longs.compare((long)val, (long)indexedVal) == 0) continue;
                            failureHappened.set(true);
                            reason.set(StringUtils.format((String)"Thread1[%d]: %d != %d", (Object[])new Object[]{j, val, indexedVal}));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        final ColumnarLongs indexed2 = (ColumnarLongs)supplier.get();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = indexed2.size() - 1; j >= 0; --j) {
                                long val = vals[j];
                                long indexedVal = indexed2.get(j);
                                if (Longs.compare((long)val, (long)indexedVal) == 0) continue;
                                failureHappened.set(true);
                                reason.set(StringUtils.format((String)"Thread2[%d]: %d != %d", (Object[])new Object[]{j, val, indexedVal}));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        finally {
            CloseQuietly.close((Closeable)indexed2);
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }
}

