/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.CompressionStrategyTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedVSizeColumnarIntsSupplierTest
extends CompressionStrategyTest {
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private Closer closer;
    private ColumnarInts columnarInts;
    private CompressedVSizeColumnarIntsSupplier supplier;
    private int[] vals;
    private final ByteOrder byteOrder;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{index}: compression={0}, byteOrder={1}")
    public static Iterable<Object[]> compressionStrategies() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompressedVSizeColumnarIntsSupplierTest(CompressionStrategy compressionStrategy, ByteOrder byteOrder) {
        super(compressionStrategy);
        this.byteOrder = byteOrder;
    }

    @Before
    public void setUp() {
        this.closer = Closer.create();
        CloseQuietly.close((Closeable)this.columnarInts);
        this.columnarInts = null;
        this.supplier = null;
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        CloseQuietly.close((Closeable)this.columnarInts);
        this.closer.close();
    }

    private void setupSimple(int chunkSize) {
        CloseQuietly.close((Closeable)this.columnarInts);
        this.vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        this.supplier = CompressedVSizeColumnarIntsSupplier.fromList((IntList)IntArrayList.wrap((int[])this.vals), (int)Ints.max((int[])this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressionStrategy)this.compressionStrategy, (Closer)this.closer);
        this.columnarInts = this.supplier.get();
    }

    private void setupSimpleWithSerde(int chunkSize) throws IOException {
        this.vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        this.makeWithSerde(chunkSize);
    }

    private void makeWithSerde(int chunkSize) throws IOException {
        CloseQuietly.close((Closeable)this.columnarInts);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedVSizeColumnarIntsSupplier theSupplier = CompressedVSizeColumnarIntsSupplier.fromList((IntList)IntArrayList.wrap((int[])this.vals), (int)Ints.max((int[])this.vals), (int)chunkSize, (ByteOrder)this.byteOrder, (CompressionStrategy)this.compressionStrategy, (Closer)this.closer);
        theSupplier.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)theSupplier.getSerializedSize(), (long)bytes.length);
        this.supplier = CompressedVSizeColumnarIntsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)this.byteOrder);
        this.columnarInts = this.supplier.get();
    }

    private void setupLargeChunks(int chunkSize, int totalSize, int maxValue) throws IOException {
        this.vals = new int[totalSize];
        Random rand = new Random(0L);
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = rand.nextInt(maxValue);
        }
        this.makeWithSerde(chunkSize);
    }

    @Test
    public void testSanity() {
        this.setupSimple(2);
        Assert.assertEquals((long)8L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(4);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(32);
        Assert.assertEquals((long)1L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test
    public void testLargeChunks() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            this.setupLargeChunks(maxChunkSize, 10 * maxChunkSize, maxValue);
            Assert.assertEquals((long)10L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
            this.setupLargeChunks(maxChunkSize, 10 * maxChunkSize + 1, maxValue);
            Assert.assertEquals((long)11L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
            this.setupLargeChunks(1, 65535, maxValue);
            Assert.assertEquals((long)65535L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
            this.setupLargeChunks(maxChunkSize / 2, 10 * (maxChunkSize / 2) + 1, maxValue);
            Assert.assertEquals((long)11L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
        }
    }

    @Test
    public void testChunkTooBig() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            try {
                this.setupLargeChunks(maxChunkSize + 1, 10 * (maxChunkSize + 1), maxValue);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((String)("chunk too big for maxValue " + maxValue), (boolean)true);
            }
        }
    }

    @Test
    public void testmaxIntsInBuffer() {
        Assert.assertEquals((long)65536L, (long)CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForBytes((int)1));
        Assert.assertEquals((long)32768L, (long)CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForBytes((int)2));
        Assert.assertEquals((long)16384L, (long)CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForBytes((int)4));
        Assert.assertEquals((long)65536L, (long)65536L);
        Assert.assertEquals((long)16384L, (long)CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForBytes((int)3));
    }

    @Test
    public void testSanityWithSerde() throws Exception {
        this.setupSimpleWithSerde(4);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimpleWithSerde(2);
        Assert.assertEquals((long)8L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentThreadReads() throws Exception {
        this.setupSimple(4);
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        int size = CompressedVSizeColumnarIntsSupplierTest.this.columnarInts.size();
                        for (int j = 0; j < size; ++j) {
                            long indexedVal;
                            long val = CompressedVSizeColumnarIntsSupplierTest.this.vals[j];
                            if (Longs.compare((long)val, (long)(indexedVal = (long)CompressedVSizeColumnarIntsSupplierTest.this.columnarInts.get(j))) == 0) continue;
                            failureHappened.set(true);
                            reason.set(StringUtils.format((String)"Thread1[%d]: %d != %d", (Object[])new Object[]{j, val, indexedVal}));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        final ColumnarInts columnarInts2 = this.supplier.get();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = columnarInts2.size() - 1; j >= 0; --j) {
                                long indexedVal;
                                long val = CompressedVSizeColumnarIntsSupplierTest.this.vals[j];
                                if (Longs.compare((long)val, (long)(indexedVal = (long)columnarInts2.get(j))) == 0) continue;
                                failureHappened.set(true);
                                reason.set(StringUtils.format((String)"Thread2[%d]: %d != %d", (Object[])new Object[]{j, val, indexedVal}));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        finally {
            CloseQuietly.close((Closeable)columnarInts2);
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }

    private void assertIndexMatchesVals() {
        Assert.assertEquals((long)this.vals.length, (long)this.columnarInts.size());
        int[] indices = new int[this.vals.length];
        int size = this.columnarInts.size();
        for (int i = 0; i < size; ++i) {
            int expected = this.vals[i];
            int actual = this.columnarInts.get(i);
            Assert.assertEquals((long)expected, (long)actual);
            indices[i] = i;
        }
        IntArrays.shuffle((int[])indices, (Random)ThreadLocalRandom.current());
        int limit = Math.min(this.columnarInts.size(), 1000);
        for (int i = 0; i < limit; ++i) {
            int k = indices[i];
            Assert.assertEquals((long)this.vals[k], (long)this.columnarInts.get(k));
        }
    }
}

