/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.incremental.AppendableIndexBuilder;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.OffheapIncrementalIndexTestSpec;

public class IncrementalIndexCreator
implements Closeable {
    public static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private final Closer closer = Closer.create();
    private final AppendableIndexSpec appendableIndexSpec;
    private final IndexCreator indexCreator;

    public static void addIndexSpec(Class<?> c, String name) {
        JSON_MAPPER.registerSubtypes(new NamedType[]{new NamedType(c, name)});
    }

    public static List<String> getAppendableIndexTypes() {
        SubtypeResolver resolver = JSON_MAPPER.getSubtypeResolver();
        DeserializationConfig config = JSON_MAPPER.getDeserializationConfig();
        AnnotatedClass cls = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)config, AppendableIndexSpec.class);
        Collection types = resolver.collectAndResolveSubtypesByClass((MapperConfig)config, cls);
        return types.stream().map(NamedType::getName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public IncrementalIndexCreator(AppendableIndexSpec spec, IndexCreator indexCreator) {
        this.appendableIndexSpec = spec;
        this.indexCreator = indexCreator;
    }

    public IncrementalIndexCreator(String indexType, IndexCreator indexCreator) throws JsonProcessingException {
        this(IncrementalIndexCreator.parseIndexType(indexType), indexCreator);
    }

    public static AppendableIndexSpec parseIndexType(String indexType) throws JsonProcessingException {
        return (AppendableIndexSpec)JSON_MAPPER.readValue(StringUtils.format((String)"{\"type\": \"%s\"}", (Object[])new Object[]{indexType}), AppendableIndexSpec.class);
    }

    public final IncrementalIndex<?> createIndex(Object ... args) {
        return this.createIndex(this.indexCreator, args);
    }

    public final IncrementalIndex<?> createIndex(IndexCreator indexCreator, Object ... args) {
        return (IncrementalIndex)this.closer.register(indexCreator.createIndex(this.appendableIndexSpec.builder(), args));
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
        if (this.appendableIndexSpec instanceof Closeable) {
            ((Closeable)this.appendableIndexSpec).close();
        }
    }

    public static List<Object[]> indexTypeCartesianProduct(Collection<?> ... c) {
        Collection[] args = new Collection[c.length + 1];
        args[0] = IncrementalIndexCreator.getAppendableIndexTypes();
        System.arraycopy(c, 0, args, 1, c.length);
        return IncrementalIndexCreator.cartesianProduct(args);
    }

    private static List<Object[]> cartesianProduct(Collection<?> ... c) {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        int curLength = c.length;
        if (curLength == 0) {
            res.add(new Object[0]);
            return res;
        }
        int curItem = curLength - 1;
        for (Object[] objList : IncrementalIndexCreator.cartesianProduct(Arrays.copyOfRange(c, 0, curItem))) {
            for (Object o : c[curItem]) {
                Object[] newObjList = Arrays.copyOf(objList, curLength);
                newObjList[curItem] = o;
                res.add(newObjList);
            }
        }
        return res;
    }

    static {
        IncrementalIndexCreator.addIndexSpec(OffheapIncrementalIndexTestSpec.class, "offheap");
    }

    public static interface IndexCreator {
        public IncrementalIndex<?> createIndex(AppendableIndexBuilder var1, Object ... var2);
    }
}

