/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexRowSizeTest
extends InitializedNullHandlingTest {
    public final IncrementalIndexCreator indexCreator;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexRowSizeTest(String indexType) throws JsonProcessingException {
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).setMaxRowCount(10000).setMaxBytesInMemory(1000L).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.getAppendableIndexTypes();
    }

    @Test
    public void testIncrementalIndexRowSizeBasic() {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        long time = System.currentTimeMillis();
        IncrementalIndex.IncrementalIndexRowResult tndResult = index.toIncrementalIndexRow((InputRow)this.toMapRow(time, "billy", "A", "joe", "B"));
        IncrementalIndexRow td1 = tndResult.getIncrementalIndexRow();
        Assert.assertEquals((long)132L, (long)td1.estimateBytesInMemory());
    }

    @Test
    public void testIncrementalIndexRowSizeArr() {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        long time = System.currentTimeMillis();
        IncrementalIndex.IncrementalIndexRowResult tndResult = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, "billy", "A", "joe", Arrays.asList("A", "B")));
        IncrementalIndexRow td1 = tndResult.getIncrementalIndexRow();
        Assert.assertEquals((long)182L, (long)td1.estimateBytesInMemory());
    }

    @Test
    public void testIncrementalIndexRowSizeComplex() {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        long time = System.currentTimeMillis();
        IncrementalIndex.IncrementalIndexRowResult tndResult = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, "billy", "nelson", "joe", Arrays.asList("123", "abcdef")));
        IncrementalIndexRow td1 = tndResult.getIncrementalIndexRow();
        Assert.assertEquals((long)206L, (long)td1.estimateBytesInMemory());
    }

    @Test
    public void testIncrementalIndexRowSizeEmptyString() {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        long time = System.currentTimeMillis();
        IncrementalIndex.IncrementalIndexRowResult tndResult = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, "billy", ""));
        IncrementalIndexRow td1 = tndResult.getIncrementalIndexRow();
        Assert.assertEquals((long)(NullHandling.sqlCompatible() ? 76L : 32L), (long)td1.estimateBytesInMemory());
    }

    private MapBasedInputRow toMapRow(long time, Object ... dimAndVal) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < dimAndVal.length; i += 2) {
            data.put((String)dimAndVal[i], dimAndVal[i + 1]);
        }
        return new MapBasedInputRow(time, (List)Lists.newArrayList(data.keySet()), data);
    }
}

