/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.SimpleRowIngestionMeters;
import org.apache.druid.testing.junit.LoggerCaptureRule;
import org.apache.logging.log4j.core.LogEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParseExceptionHandlerTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    @Rule
    public LoggerCaptureRule logger = new LoggerCaptureRule(ParseExceptionHandler.class);

    @Test
    public void testMetricWhenAllConfigurationsAreTurnedOff() {
        ParseException parseException = new ParseException("test", new Object[0]);
        SimpleRowIngestionMeters rowIngestionMeters = new SimpleRowIngestionMeters();
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler((RowIngestionMeters)rowIngestionMeters, false, Integer.MAX_VALUE, 0);
        IntStream.range(0, 100).forEach(i -> {
            parseExceptionHandler.handle(parseException);
            Assert.assertEquals((long)(i + 1), (long)rowIngestionMeters.getUnparseable());
        });
    }

    @Test
    public void testLogParseExceptions() {
        ParseException parseException = new ParseException("test", new Object[0]);
        SimpleRowIngestionMeters rowIngestionMeters = new SimpleRowIngestionMeters();
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler((RowIngestionMeters)rowIngestionMeters, true, Integer.MAX_VALUE, 0);
        parseExceptionHandler.handle(parseException);
        List logEvents = this.logger.getLogEvents();
        Assert.assertEquals((long)1L, (long)logEvents.size());
        String logMessage = ((LogEvent)logEvents.get(0)).getMessage().getFormattedMessage();
        Assert.assertTrue((boolean)logMessage.contains("Encountered parse exception"));
    }

    @Test
    public void testGetSavedParseExceptionsReturnNullWhenMaxSavedParseExceptionsIsZero() {
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler((RowIngestionMeters)new SimpleRowIngestionMeters(), false, Integer.MAX_VALUE, 0);
        Assert.assertNull((Object)parseExceptionHandler.getSavedParseExceptions());
    }

    @Test
    public void testMaxAllowedParseExceptionsThrowExceptionWhenItHitsMax() {
        ParseException parseException = new ParseException("test", new Object[0]);
        int maxAllowedParseExceptions = 3;
        SimpleRowIngestionMeters rowIngestionMeters = new SimpleRowIngestionMeters();
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler((RowIngestionMeters)rowIngestionMeters, false, 3, 0);
        IntStream.range(0, 3).forEach(i -> parseExceptionHandler.handle(parseException));
        Assert.assertEquals((long)3L, (long)rowIngestionMeters.getUnparseable());
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Max parse exceptions[3] exceeded");
        try {
            parseExceptionHandler.handle(parseException);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((long)4L, (long)rowIngestionMeters.getUnparseable());
            throw e;
        }
    }

    @Test
    public void testGetSavedParseExceptionsReturnMostRecentParseExceptions() {
        int i;
        int exceptionCounter;
        int maxSavedParseExceptions = 3;
        SimpleRowIngestionMeters rowIngestionMeters = new SimpleRowIngestionMeters();
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler((RowIngestionMeters)rowIngestionMeters, false, Integer.MAX_VALUE, 3);
        Assert.assertNotNull((Object)parseExceptionHandler.getSavedParseExceptions());
        for (exceptionCounter = 0; exceptionCounter < 3; ++exceptionCounter) {
            parseExceptionHandler.handle(new ParseException(StringUtils.format((String)"test %d", (Object[])new Object[]{exceptionCounter}), new Object[0]));
        }
        Assert.assertEquals((long)3L, (long)rowIngestionMeters.getUnparseable());
        Assert.assertEquals((long)3L, (long)parseExceptionHandler.getSavedParseExceptions().size());
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)StringUtils.format((String)"test %d", (Object[])new Object[]{i}), (Object)((ParseException)parseExceptionHandler.getSavedParseExceptions().get(i)).getMessage());
        }
        while (exceptionCounter < 5) {
            parseExceptionHandler.handle(new ParseException(StringUtils.format((String)"test %d", (Object[])new Object[]{exceptionCounter}), new Object[0]));
            ++exceptionCounter;
        }
        Assert.assertEquals((long)5L, (long)rowIngestionMeters.getUnparseable());
        Assert.assertEquals((long)3L, (long)parseExceptionHandler.getSavedParseExceptions().size());
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)StringUtils.format((String)"test %d", (Object[])new Object[]{i + 2}), (Object)((ParseException)parseExceptionHandler.getSavedParseExceptions().get(i)).getMessage());
        }
    }
}

