/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.lookup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.config.NullHandlingTest;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LookupJoinableTest
extends NullHandlingTest {
    private static final String UNKNOWN_COLUMN = "UNKNOWN_COLUMN";
    private static final String SEARCH_KEY_VALUE = "SEARCH_KEY_VALUE";
    private static final String SEARCH_KEY_NULL_VALUE = "SEARCH_KEY_NULL_VALUE";
    private static final String SEARCH_VALUE_VALUE = "SEARCH_VALUE_VALUE";
    private static final String SEARCH_VALUE_UNKNOWN = "SEARCH_VALUE_UNKNOWN";
    @Mock
    private LookupExtractor extractor;
    private LookupJoinable target;

    @Before
    public void setUp() {
        HashSet<String> keyValues = new HashSet<String>();
        keyValues.add("foo");
        keyValues.add("bar");
        keyValues.add("");
        keyValues.add(null);
        ((LookupExtractor)Mockito.doReturn((Object)SEARCH_VALUE_VALUE).when((Object)this.extractor)).apply(SEARCH_KEY_VALUE);
        ((LookupExtractor)Mockito.doReturn((Object)ImmutableList.of((Object)SEARCH_KEY_VALUE)).when((Object)this.extractor)).unapply(SEARCH_VALUE_VALUE);
        ((LookupExtractor)Mockito.doReturn((Object)ImmutableList.of()).when((Object)this.extractor)).unapply(SEARCH_VALUE_UNKNOWN);
        ((LookupExtractor)Mockito.doReturn((Object)true).when((Object)this.extractor)).canGetKeySet();
        ((LookupExtractor)Mockito.doReturn(keyValues).when((Object)this.extractor)).keySet();
        this.target = LookupJoinable.wrap((LookupExtractor)this.extractor);
    }

    @Test
    public void getAvailableColumnShouldReturnOnlyTwoColumns() {
        List colummns = this.target.getAvailableColumns();
        Assert.assertEquals((long)2L, (long)colummns.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"k", (Object)"v"), (Object)colummns);
    }

    @Test
    public void getCardinalityForUnknownColumnShouldReturnUnknown() {
        int cardinality = this.target.getCardinality(UNKNOWN_COLUMN);
        Assert.assertEquals((long)-1L, (long)cardinality);
    }

    @Test
    public void getCardinalityForKeyColumnShouldReturnUnknown() {
        int cardinality = this.target.getCardinality("k");
        Assert.assertEquals((long)-1L, (long)cardinality);
    }

    @Test
    public void getCardinalityForValueColumnShouldReturnUnknown() {
        int cardinality = this.target.getCardinality("v");
        Assert.assertEquals((long)-1L, (long)cardinality);
    }

    @Test
    public void getColumnCapabilitiesForKeyColumnShouldReturnStringCaps() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities("k");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
    }

    @Test
    public void getColumnCapabilitiesForValueColumnShouldReturnStringCaps() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities("v");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
    }

    @Test
    public void getColumnCapabilitiesForUnknownColumnShouldReturnNull() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities(UNKNOWN_COLUMN);
        Assert.assertNull((Object)capabilities);
    }

    @Test
    public void getCorrelatedColummnValuesMissingSearchColumnShouldReturnEmptySet() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(UNKNOWN_COLUMN, SEARCH_KEY_VALUE, "v", 0L, false);
        Assert.assertFalse((boolean)correlatedValues.isPresent());
    }

    @Test
    public void getCorrelatedColummnValuesMissingRetrievalColumnShouldReturnEmptySet() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_VALUE, UNKNOWN_COLUMN, 0L, false);
        Assert.assertFalse((boolean)correlatedValues.isPresent());
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyAndRetrieveKeyColumnShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_VALUE, "k", 0L, false);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_KEY_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyAndRetrieveValueColumnShouldReturnExtractedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_VALUE, "v", 0L, false);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_VALUE_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyMissingAndRetrieveValueColumnShouldReturnExtractedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_NULL_VALUE, "v", 0L, false);
        Assert.assertEquals(Optional.of(Collections.singleton(null)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveValueColumnAndNonKeyColumnSearchDisabledShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "v", 10L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
        correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "k", 10L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveValueColumnShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "v", 0L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_VALUE_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveKeyColumnShouldReturnUnAppliedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "k", 10L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_KEY_VALUE)), (Object)correlatedValues);
    }

    @Test
    @Ignore
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveKeyColumnWithMaxLimitSetShouldHonorMaxLimit() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "k", 0L, true);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchUnknownValueAndRetrieveKeyColumnShouldReturnNoCorrelatedValues() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_UNKNOWN, "k", 10L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of()), (Object)correlatedValues);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForValueColumnShouldReturnEmpty() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique("v", Integer.MAX_VALUE);
        Assert.assertEquals(Optional.empty(), (Object)values);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForKeyColumnShouldReturnValues() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique("k", Integer.MAX_VALUE);
        Assert.assertEquals(Optional.of(NullHandling.replaceWithDefault() ? ImmutableSet.of((Object)"foo", (Object)"bar") : ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"")), (Object)values);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForKeyColumnWithLowMaxValuesShouldReturnEmpty() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique("k", 1);
        Assert.assertEquals(Optional.empty(), (Object)values);
    }
}

