/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.MapIndex;
import org.apache.druid.segment.join.table.RowBasedIndexBuilder;
import org.apache.druid.segment.join.table.UniqueLongArrayIndex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RowBasedIndexBuilderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_stringKey_uniqueKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ValueType.STRING).add((Object)"abc").add((Object)"").add(null).add((Object)"1").add((Object)"def");
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ValueType.STRING, (Object)index.keyType());
        Assert.assertTrue((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intList(0), (Object)index.find((Object)"abc"));
        Assert.assertEquals((Object)this.intList(1), (Object)index.find((Object)""));
        Assert.assertEquals((Object)this.intList(3), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intList(3), (Object)index.find((Object)"1"));
        Assert.assertEquals((Object)this.intList(4), (Object)index.find((Object)"def"));
        Assert.assertEquals((Object)this.intList(new int[0]), (Object)index.find(null));
        Assert.assertEquals((Object)this.intList(new int[0]), (Object)index.find((Object)"nonexistent"));
        this.expectedException.expect(UnsupportedOperationException.class);
        index.findUniqueLong(0L);
    }

    @Test
    public void test_stringKey_duplicateKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ValueType.STRING).add((Object)"abc").add((Object)"").add(null).add((Object)"abc").add((Object)"1").add((Object)"def");
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ValueType.STRING, (Object)index.keyType());
        Assert.assertFalse((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intList(0, 3), (Object)index.find((Object)"abc"));
        Assert.assertEquals((Object)this.intList(1), (Object)index.find((Object)""));
        Assert.assertEquals((Object)this.intList(4), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intList(4), (Object)index.find((Object)"1"));
        Assert.assertEquals((Object)this.intList(5), (Object)index.find((Object)"def"));
        Assert.assertEquals((Object)this.intList(new int[0]), (Object)index.find(null));
        Assert.assertEquals((Object)this.intList(new int[0]), (Object)index.find((Object)"nonexistent"));
        this.expectedException.expect(UnsupportedOperationException.class);
        index.findUniqueLong(0L);
    }

    @Test
    public void test_longKey_uniqueKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ValueType.LONG).add((Object)1).add((Object)5).add((Object)2);
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(UniqueLongArrayIndex.class));
        Assert.assertEquals((Object)ValueType.LONG, (Object)index.keyType());
        Assert.assertTrue((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intList(0), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intList(1), (Object)index.find((Object)5L));
        Assert.assertEquals((Object)this.intList(2), (Object)index.find((Object)2L));
        Assert.assertEquals((Object)this.intList(new int[0]), (Object)index.find((Object)3L));
        Assert.assertEquals((long)0L, (long)index.findUniqueLong(1L));
        Assert.assertEquals((long)1L, (long)index.findUniqueLong(5L));
        Assert.assertEquals((long)2L, (long)index.findUniqueLong(2L));
        Assert.assertEquals((long)-1L, (long)index.findUniqueLong(3L));
    }

    @Test
    public void test_longKey_uniqueKeys_farApart() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ValueType.LONG).add((Object)1).add((Object)10000000).add((Object)2);
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ValueType.LONG, (Object)index.keyType());
        Assert.assertTrue((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intList(0), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intList(1), (Object)index.find((Object)10000000L));
        Assert.assertEquals((Object)this.intList(2), (Object)index.find((Object)2L));
        Assert.assertEquals((Object)this.intList(new int[0]), (Object)index.find((Object)3L));
        Assert.assertEquals((long)0L, (long)index.findUniqueLong(1L));
        Assert.assertEquals((long)1L, (long)index.findUniqueLong(10000000L));
        Assert.assertEquals((long)2L, (long)index.findUniqueLong(2L));
        Assert.assertEquals((long)-1L, (long)index.findUniqueLong(3L));
    }

    @Test
    public void test_longKey_duplicateKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ValueType.LONG).add((Object)1).add((Object)5).add((Object)1).add((Object)2);
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ValueType.LONG, (Object)index.keyType());
        Assert.assertFalse((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intList(0, 2), (Object)index.find((Object)"1"));
        Assert.assertEquals((Object)this.intList(0, 2), (Object)index.find((Object)1));
        Assert.assertEquals((Object)this.intList(0, 2), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intList(1), (Object)index.find((Object)5L));
        Assert.assertEquals((Object)this.intList(3), (Object)index.find((Object)2L));
        Assert.assertEquals((Object)this.intList(new int[0]), (Object)index.find((Object)3L));
        this.expectedException.expect(UnsupportedOperationException.class);
        index.findUniqueLong(5L);
    }

    public IntList intList(int ... ints) {
        IntArrayList retVal = new IntArrayList(ints.length);
        for (int i : ints) {
            retVal.add(i);
        }
        return retVal;
    }
}

