/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.concurrent.ExecutorServiceConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.utils.JvmUtils;
import org.skife.config.Config;

public abstract class DruidProcessingConfig
extends ExecutorServiceConfig
implements ColumnConfig {
    private static final Logger log = new Logger(DruidProcessingConfig.class);
    public static final int DEFAULT_NUM_MERGE_BUFFERS = -1;
    public static final HumanReadableBytes DEFAULT_PROCESSING_BUFFER_SIZE_BYTES = HumanReadableBytes.valueOf((int)-1);
    public static final int MAX_DEFAULT_PROCESSING_BUFFER_SIZE_BYTES = 0x40000000;
    public static final int DEFAULT_MERGE_POOL_AWAIT_SHUTDOWN_MILLIS = 60000;
    private AtomicReference<Integer> computedBufferSizeBytes = new AtomicReference();

    @Config(value={"druid.computation.buffer.size", "${base_path}.buffer.sizeBytes"})
    public HumanReadableBytes intermediateComputeSizeBytesConfigured() {
        return DEFAULT_PROCESSING_BUFFER_SIZE_BYTES;
    }

    public int intermediateComputeSizeBytes() {
        long directSizeBytes;
        HumanReadableBytes sizeBytesConfigured = this.intermediateComputeSizeBytesConfigured();
        if (!DEFAULT_PROCESSING_BUFFER_SIZE_BYTES.equals((Object)sizeBytesConfigured)) {
            if (sizeBytesConfigured.getBytes() > Integer.MAX_VALUE) {
                throw new IAE("druid.processing.buffer.sizeBytes must be less than 2GiB", new Object[0]);
            }
            return sizeBytesConfigured.getBytesInInt();
        }
        if (this.computedBufferSizeBytes.get() != null) {
            return this.computedBufferSizeBytes.get();
        }
        try {
            directSizeBytes = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
            log.info("Detected max direct memory size of [%,d] bytes", new Object[]{directSizeBytes});
        }
        catch (UnsupportedOperationException e) {
            directSizeBytes = DruidProcessingConfig.computeMaxMemoryFromMaxHeapSize();
            log.info("Defaulting to at most [%,d] bytes (25%% of max heap size) of direct memory for computation buffers", new Object[]{directSizeBytes});
        }
        int numProcessingThreads = this.getNumThreads();
        int numMergeBuffers = this.getNumMergeBuffers();
        int totalNumBuffers = numMergeBuffers + numProcessingThreads;
        int sizePerBuffer = (int)((double)directSizeBytes / (double)(totalNumBuffers + 1));
        int computedSizePerBuffer = Math.min(sizePerBuffer, 0x40000000);
        if (this.computedBufferSizeBytes.compareAndSet(null, computedSizePerBuffer)) {
            log.info("Auto sizing buffers to [%,d] bytes each for [%,d] processing and [%,d] merge buffers", new Object[]{computedSizePerBuffer, numProcessingThreads, numMergeBuffers});
        }
        return computedSizePerBuffer;
    }

    public static long computeMaxMemoryFromMaxHeapSize() {
        return Runtime.getRuntime().maxMemory() / 4L;
    }

    @Config(value={"druid.computation.buffer.poolCacheMaxCount", "${base_path}.buffer.poolCacheMaxCount"})
    public int poolCacheMaxCount() {
        return Integer.MAX_VALUE;
    }

    @Config(value={"${base_path}.numThreads"})
    public int getNumThreadsConfigured() {
        return -1;
    }

    public int getNumMergeBuffers() {
        int numMergeBuffersConfigured = this.getNumMergeBuffersConfigured();
        if (numMergeBuffersConfigured != -1) {
            return numMergeBuffersConfigured;
        }
        return Math.max(2, this.getNumThreads() / 4);
    }

    @Config(value={"${base_path}.numMergeBuffers"})
    public int getNumMergeBuffersConfigured() {
        return -1;
    }

    @Override
    @Config(value={"${base_path}.columnCache.sizeBytes"})
    public int columnCacheSizeBytes() {
        return 0;
    }

    @Config(value={"${base_path}.fifo"})
    public boolean isFifo() {
        return false;
    }

    @Config(value={"${base_path}.tmpDir"})
    public String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    @Config(value={"${base_path}.merge.useParallelMergePool"})
    public boolean useParallelMergePoolConfigured() {
        return true;
    }

    public boolean useParallelMergePool() {
        boolean useParallelMergePoolConfigured = this.useParallelMergePoolConfigured();
        int parallelism = this.getMergePoolParallelism();
        if (parallelism > 2) {
            return useParallelMergePoolConfigured;
        }
        if (useParallelMergePoolConfigured) {
            log.debug("Parallel merge pool is enabled, but there are not enough cores to enable parallel merges: %s", new Object[]{parallelism});
        }
        return false;
    }

    @Config(value={"${base_path}.merge.pool.parallelism"})
    public int getMergePoolParallelismConfigured() {
        return -1;
    }

    public int getMergePoolParallelism() {
        int poolParallelismConfigured = this.getMergePoolParallelismConfigured();
        if (poolParallelismConfigured != -1) {
            return poolParallelismConfigured;
        }
        return (int)Math.ceil((double)JvmUtils.getRuntimeInfo().getAvailableProcessors() * 0.75);
    }

    @Config(value={"${base_path}.merge.pool.awaitShutdownMillis"})
    public long getMergePoolAwaitShutdownMillis() {
        return 60000L;
    }

    @Config(value={"${base_path}.merge.pool.defaultMaxQueryParallelism"})
    public int getMergePoolDefaultMaxQueryParallelism() {
        return (int)Math.max((double)JvmUtils.getRuntimeInfo().getAvailableProcessors() * 0.5, 1.0);
    }

    @Config(value={"${base_path}.merge.task.targetRunTimeMillis"})
    public int getMergePoolTargetTaskRunTimeMillis() {
        return 100;
    }

    @Config(value={"${base_path}.merge.task.initialYieldNumRows"})
    public int getMergePoolTaskInitialYieldRows() {
        return 16384;
    }

    @Config(value={"${base_path}.merge.task.smallBatchNumRows"})
    public int getMergePoolSmallBatchRows() {
        return 4096;
    }
}

