/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.AbstractPrioritizedQueryRunnerCallable;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;

public class GroupByMergedQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(GroupByMergedQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final QueryWatcher queryWatcher;
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final QueryProcessingPool queryProcessingPool;

    public GroupByMergedQueryRunner(QueryProcessingPool queryProcessingPool, Supplier<GroupByQueryConfig> configSupplier, QueryWatcher queryWatcher, NonBlockingPool<ByteBuffer> bufferPool, Iterable<QueryRunner<T>> queryables) {
        this.queryProcessingPool = queryProcessingPool;
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable((Iterable)Iterables.filter(queryables, (Predicate)Predicates.notNull()));
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final ResponseContext responseContext) {
        final GroupByQuery query = (GroupByQuery)queryPlus.getQuery();
        GroupByQueryConfig querySpecificConfig = ((GroupByQueryConfig)this.configSupplier.get()).withOverrides(query);
        final boolean isSingleThreaded = querySpecificConfig.isSingleThreaded();
        final Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, null, querySpecificConfig, this.bufferPool);
        final Pair bySegmentAccumulatorPair = GroupByQueryHelper.createBySegmentAccumulatorPair();
        final boolean bySegment = QueryContexts.isBySegment(query);
        final int priority = QueryContexts.getPriority(query);
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        ArrayList futures = Lists.newArrayList((Iterable)Iterables.transform(this.queryables, (Function)new Function<QueryRunner<T>, ListenableFuture<Void>>(){

            public ListenableFuture<Void> apply(final QueryRunner<T> input) {
                if (input == null) {
                    throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                }
                ListenableFuture future = GroupByMergedQueryRunner.this.queryProcessingPool.submitRunnerTask(new AbstractPrioritizedQueryRunnerCallable<Void, T>(priority, input){

                    @Override
                    public Void call() {
                        try {
                            if (bySegment) {
                                input.run(threadSafeQueryPlus, responseContext).accumulate(bySegmentAccumulatorPair.lhs, (Accumulator)bySegmentAccumulatorPair.rhs);
                            } else {
                                input.run(threadSafeQueryPlus, responseContext).accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
                            }
                            return null;
                        }
                        catch (QueryInterruptedException e) {
                            throw new RuntimeException((Throwable)((Object)e));
                        }
                        catch (Exception e) {
                            log.error((Throwable)e, "Exception with one of the sequences!", new Object[0]);
                            Throwables.propagateIfPossible((Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                });
                if (isSingleThreaded) {
                    GroupByMergedQueryRunner.this.waitForFutureCompletion(query, (List)ImmutableList.of(future), (IncrementalIndex)indexAccumulatorPair.lhs);
                }
                return future;
            }
        }));
        if (!isSingleThreaded) {
            this.waitForFutureCompletion(query, futures, (IncrementalIndex)indexAccumulatorPair.lhs);
        }
        if (bySegment) {
            return Sequences.simple((Iterable)((Iterable)bySegmentAccumulatorPair.lhs));
        }
        return Sequences.withBaggage((Sequence)Sequences.simple((Iterable)Iterables.transform(((IncrementalIndex)indexAccumulatorPair.lhs).iterableWithPostAggregations(null, query.isDescending()), (Function)new Function<Row, T>(){

            public T apply(Row input) {
                return input;
            }
        })), (Closeable)((Closeable)indexAccumulatorPair.lhs));
    }

    private void waitForFutureCompletion(GroupByQuery query, List<ListenableFuture<Void>> futures, IncrementalIndex<?> closeOnFailure) {
        ListenableFuture future = Futures.allAsList(futures);
        try {
            this.queryWatcher.registerQueryFuture(query, future);
            if (QueryContexts.hasTimeout(query)) {
                future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
            GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
            closeOnFailure.close();
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            closeOnFailure.close();
            throw new QueryInterruptedException(e);
        }
        catch (TimeoutException e) {
            closeOnFailure.close();
            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
            GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
            throw new QueryTimeoutException(StringUtils.nonStrictFormat((String)"Query [%s] timed out", (Object[])new Object[]{query.getId()}));
        }
        catch (ExecutionException e) {
            GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
            closeOnFailure.close();
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

