/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;

@JsonTypeName(value="query")
public class QueryDataSource
implements DataSource {
    @JsonProperty
    private final Query query;

    @JsonCreator
    public QueryDataSource(@JsonProperty(value="query") Query query) {
        this.query = (Query)Preconditions.checkNotNull((Object)query, (Object)"'query' must be nonnull");
    }

    @Override
    public Set<String> getTableNames() {
        return this.query.getDataSource().getTableNames();
    }

    @JsonProperty
    public Query getQuery() {
        return this.query;
    }

    @Override
    public List<DataSource> getChildren() {
        return Collections.singletonList(this.query.getDataSource());
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != 1) {
            throw new IAE("Must have exactly one child", new Object[0]);
        }
        return new QueryDataSource(this.query.withDataSource((DataSource)Iterables.getOnlyElement(children)));
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.query.getDataSource().isGlobal();
    }

    @Override
    public boolean isConcrete() {
        return false;
    }

    public String toString() {
        return this.query.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDataSource that = (QueryDataSource)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }
}

