/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.math.expr.SettableObjectBinding;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleSumAggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorInputBindings;
import org.apache.druid.query.aggregation.ExpressionLambdaBufferAggregator;
import org.apache.druid.query.aggregation.LongSumAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSelectors;

public class ExpressionLambdaAggregatorFactory
extends AggregatorFactory {
    private static final String FINALIZE_IDENTIFIER = "o";
    private static final String COMPARE_O1 = "o1";
    private static final String COMPARE_O2 = "o2";
    private static final String DEFAULT_ACCUMULATOR_ID = "__acc";
    private static final int MIN_SIZE_BYTES = 10;
    public static final HumanReadableBytes DEFAULT_MAX_SIZE_BYTES = new HumanReadableBytes(1024L);
    private final String name;
    @Nullable
    private final Set<String> fields;
    private final String accumulatorId;
    private final String foldExpressionString;
    private final String initialValueExpressionString;
    private final String initialCombineValueExpressionString;
    private final boolean isNullUnlessAggregated;
    private final String combineExpressionString;
    @Nullable
    private final String compareExpressionString;
    @Nullable
    private final String finalizeExpressionString;
    private final ExprMacroTable macroTable;
    private final Supplier<ExprEval<?>> initialValue;
    private final Supplier<ExprEval<?>> initialCombineValue;
    private final Supplier<Expr> foldExpression;
    private final Supplier<Expr> combineExpression;
    private final Supplier<Expr> compareExpression;
    private final Supplier<Expr> finalizeExpression;
    private final HumanReadableBytes maxSizeBytes;
    private final Supplier<SettableObjectBinding> compareBindings = Suppliers.memoize(() -> new SettableObjectBinding(2));
    private final Supplier<SettableObjectBinding> combineBindings = Suppliers.memoize(() -> new SettableObjectBinding(2));
    private final Supplier<SettableObjectBinding> finalizeBindings = Suppliers.memoize(() -> new SettableObjectBinding(1));
    private final Supplier<Expr.InputBindingInspector> finalizeInspector;

    @JsonCreator
    public ExpressionLambdaAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fields") @Nullable Set<String> fields, @JsonProperty(value="accumulatorIdentifier") @Nullable String accumulatorIdentifier, @JsonProperty(value="initialValue") String initialValue, @JsonProperty(value="initialCombineValue") @Nullable String initialCombineValue, @JsonProperty(value="isNullUnlessAggregated") @Nullable Boolean isNullUnlessAggregated, @JsonProperty(value="fold") String foldExpression, @JsonProperty(value="combine") @Nullable String combineExpression, @JsonProperty(value="compare") @Nullable String compareExpression, @JsonProperty(value="finalize") @Nullable String finalizeExpression, @JsonProperty(value="maxSizeBytes") @Nullable HumanReadableBytes maxSizeBytes, @JacksonInject ExprMacroTable macroTable) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.name = name;
        this.fields = fields;
        this.accumulatorId = accumulatorIdentifier != null ? accumulatorIdentifier : DEFAULT_ACCUMULATOR_ID;
        this.initialValueExpressionString = initialValue;
        this.initialCombineValueExpressionString = initialCombineValue == null ? initialValue : initialCombineValue;
        this.isNullUnlessAggregated = isNullUnlessAggregated == null ? NullHandling.sqlCompatible() : isNullUnlessAggregated;
        this.foldExpressionString = foldExpression;
        if (combineExpression != null) {
            this.combineExpressionString = combineExpression;
        } else {
            Preconditions.checkArgument((fields != null && fields.size() == 1 ? 1 : 0) != 0, (Object)"Must have a single input field if no combine expression is supplied");
            this.combineExpressionString = StringUtils.replace((String)foldExpression, (String)((String)Iterables.getOnlyElement(fields)), (String)name);
        }
        this.compareExpressionString = compareExpression;
        this.finalizeExpressionString = finalizeExpression;
        this.macroTable = macroTable;
        this.initialValue = Suppliers.memoize(() -> {
            Expr parsed = Parser.parse((String)initialValue, (ExprMacroTable)macroTable);
            Preconditions.checkArgument((boolean)parsed.isLiteral(), (Object)"initial value must be constant");
            return parsed.eval(ExprUtils.nilBindings());
        });
        this.initialCombineValue = Suppliers.memoize(() -> {
            Expr parsed = Parser.parse((String)this.initialCombineValueExpressionString, (ExprMacroTable)macroTable);
            Preconditions.checkArgument((boolean)parsed.isLiteral(), (Object)"initial combining value must be constant");
            return parsed.eval(ExprUtils.nilBindings());
        });
        this.foldExpression = Parser.lazyParse((String)this.foldExpressionString, (ExprMacroTable)macroTable);
        this.combineExpression = Parser.lazyParse((String)this.combineExpressionString, (ExprMacroTable)macroTable);
        this.compareExpression = Parser.lazyParse((String)this.compareExpressionString, (ExprMacroTable)macroTable);
        this.finalizeInspector = Suppliers.memoize(() -> InputBindings.inspectorFromTypeMap((Map)ImmutableMap.of((Object)FINALIZE_IDENTIFIER, (Object)((ExprEval)this.initialCombineValue.get()).type())));
        this.finalizeExpression = Parser.lazyParse((String)this.finalizeExpressionString, (ExprMacroTable)macroTable);
        this.maxSizeBytes = maxSizeBytes != null ? maxSizeBytes : DEFAULT_MAX_SIZE_BYTES;
        Preconditions.checkArgument((this.maxSizeBytes.getBytesInInt() >= 10 ? 1 : 0) != 0);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    @Nullable
    public Set<String> getFields() {
        return this.fields;
    }

    @JsonProperty
    @Nullable
    public String getAccumulatorIdentifier() {
        return this.accumulatorId;
    }

    @JsonProperty(value="initialValue")
    public String getInitialValueExpressionString() {
        return this.initialValueExpressionString;
    }

    @JsonProperty(value="initialCombineValue")
    public String getInitialCombineValueExpressionString() {
        return this.initialCombineValueExpressionString;
    }

    @JsonProperty(value="isNullUnlessAggregated")
    public boolean getIsNullUnlessAggregated() {
        return this.isNullUnlessAggregated;
    }

    @JsonProperty(value="fold")
    public String getFoldExpressionString() {
        return this.foldExpressionString;
    }

    @JsonProperty(value="combine")
    public String getCombineExpressionString() {
        return this.combineExpressionString;
    }

    @JsonProperty(value="compare")
    @Nullable
    public String getCompareExpressionString() {
        return this.compareExpressionString;
    }

    @JsonProperty(value="finalize")
    @Nullable
    public String getFinalizeExpressionString() {
        return this.finalizeExpressionString;
    }

    @JsonProperty(value="maxSizeBytes")
    public HumanReadableBytes getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(71).appendStrings(this.fields).appendString(this.initialValueExpressionString).appendString(this.initialCombineValueExpressionString).appendCacheable((Cacheable)this.foldExpression.get()).appendCacheable((Cacheable)this.combineExpression.get()).appendCacheable((Cacheable)this.combineExpression.get()).appendCacheable((Cacheable)this.finalizeExpression.get()).appendInt(this.maxSizeBytes.getBytesInInt()).build();
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        FactorizePlan thePlan = new FactorizePlan(metricFactory);
        return new ExpressionLambdaAggregator(thePlan.getExpression(), thePlan.getBindings(), this.isNullUnlessAggregated, this.maxSizeBytes.getBytesInInt());
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        FactorizePlan thePlan = new FactorizePlan(metricFactory);
        return new ExpressionLambdaBufferAggregator(thePlan.getExpression(), thePlan.getInitialValue(), thePlan.getBindings(), this.isNullUnlessAggregated, this.maxSizeBytes.getBytesInInt());
    }

    @Override
    public Comparator getComparator() {
        Expr compareExpr = (Expr)this.compareExpression.get();
        if (compareExpr != null) {
            return (o1, o2) -> compareExpr.eval((Expr.ObjectBinding)((SettableObjectBinding)this.compareBindings.get()).withBinding(COMPARE_O1, o1).withBinding(COMPARE_O2, o2)).asInt();
        }
        switch (((ExprEval)this.initialValue.get()).type()) {
            case LONG: {
                return LongSumAggregator.COMPARATOR;
            }
            case DOUBLE: {
                return DoubleSumAggregator.COMPARATOR;
            }
        }
        return Comparators.naturalNullsFirst();
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        return ((Expr)this.combineExpression.get()).eval((Expr.ObjectBinding)((SettableObjectBinding)this.combineBindings.get()).withBinding(this.accumulatorId, lhs).withBinding(this.name, rhs)).value();
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        Expr finalizeExpr = (Expr)this.finalizeExpression.get();
        if (finalizeExpr != null) {
            return finalizeExpr.eval((Expr.ObjectBinding)((SettableObjectBinding)this.finalizeBindings.get()).withBinding(FINALIZE_IDENTIFIER, object)).value();
        }
        return object;
    }

    @Override
    public List<String> requiredFields() {
        if (this.fields == null) {
            return ((Expr)this.combineExpression.get()).analyzeInputs().getRequiredBindingsList();
        }
        return ((Expr)this.foldExpression.get()).analyzeInputs().getRequiredBindingsList();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new ExpressionLambdaAggregatorFactory(this.name, null, this.accumulatorId, this.initialValueExpressionString, this.initialCombineValueExpressionString, this.isNullUnlessAggregated, this.foldExpressionString, this.combineExpressionString, this.compareExpressionString, this.finalizeExpressionString, this.maxSizeBytes, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new ExpressionLambdaAggregatorFactory(this.name, this.fields, this.accumulatorId, this.initialValueExpressionString, this.initialCombineValueExpressionString, this.isNullUnlessAggregated, this.foldExpressionString, this.combineExpressionString, this.compareExpressionString, this.finalizeExpressionString, this.maxSizeBytes, this.macroTable));
    }

    @Override
    public ValueType getType() {
        if (this.fields == null) {
            return ExprType.toValueType((ExprType)((ExprEval)this.initialCombineValue.get()).type());
        }
        return ExprType.toValueType((ExprType)((ExprEval)this.initialValue.get()).type());
    }

    @Override
    public ValueType getFinalizedType() {
        Expr finalizeExpr = (Expr)this.finalizeExpression.get();
        ExprEval initialVal = (ExprEval)this.initialCombineValue.get();
        if (finalizeExpr != null) {
            ExprType type = finalizeExpr.getOutputType((Expr.InputBindingInspector)this.finalizeInspector.get());
            if (type == null) {
                type = initialVal.type();
            }
            return ExprType.toValueType((ExprType)type);
        }
        return ExprType.toValueType((ExprType)initialVal.type());
    }

    @Override
    public int getMaxIntermediateSize() {
        return this.getType().isNumeric() ? 10 : this.maxSizeBytes.getBytesInInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionLambdaAggregatorFactory that = (ExpressionLambdaAggregatorFactory)o;
        return this.maxSizeBytes.equals((Object)that.maxSizeBytes) && this.name.equals(that.name) && Objects.equals(this.fields, that.fields) && this.accumulatorId.equals(that.accumulatorId) && this.foldExpressionString.equals(that.foldExpressionString) && this.initialValueExpressionString.equals(that.initialValueExpressionString) && this.initialCombineValueExpressionString.equals(that.initialCombineValueExpressionString) && this.isNullUnlessAggregated == that.isNullUnlessAggregated && this.combineExpressionString.equals(that.combineExpressionString) && Objects.equals(this.compareExpressionString, that.compareExpressionString) && Objects.equals(this.finalizeExpressionString, that.finalizeExpressionString);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.accumulatorId, this.foldExpressionString, this.initialValueExpressionString, this.initialCombineValueExpressionString, this.isNullUnlessAggregated, this.combineExpressionString, this.compareExpressionString, this.finalizeExpressionString, this.maxSizeBytes);
    }

    public String toString() {
        return "ExpressionLambdaAggregatorFactory{name='" + this.name + '\'' + ", fields=" + this.fields + ", accumulatorId='" + this.accumulatorId + '\'' + ", foldExpressionString='" + this.foldExpressionString + '\'' + ", initialValueExpressionString='" + this.initialValueExpressionString + '\'' + ", initialCombineValueExpressionString='" + this.initialCombineValueExpressionString + '\'' + ", nullUnlessAggregated='" + this.isNullUnlessAggregated + '\'' + ", combineExpressionString='" + this.combineExpressionString + '\'' + ", compareExpressionString='" + this.compareExpressionString + '\'' + ", finalizeExpressionString='" + this.finalizeExpressionString + '\'' + ", maxSizeBytes=" + this.maxSizeBytes + '}';
    }

    private class FactorizePlan {
        private final ExpressionPlan plan;
        private final ExprEval<?> seed;
        private final ExpressionLambdaAggregatorInputBindings bindings;

        FactorizePlan(ColumnSelectorFactory metricFactory) {
            List columns;
            if (ExpressionLambdaAggregatorFactory.this.fields != null) {
                this.plan = ExpressionPlanner.plan(this.inspectorWithAccumulator(metricFactory), (Expr)ExpressionLambdaAggregatorFactory.this.foldExpression.get());
                this.seed = (ExprEval)ExpressionLambdaAggregatorFactory.this.initialValue.get();
                columns = this.plan.getAnalysis().getRequiredBindingsList();
            } else {
                this.plan = ExpressionPlanner.plan(this.inspectorWithAccumulator(metricFactory), (Expr)ExpressionLambdaAggregatorFactory.this.combineExpression.get());
                this.seed = (ExprEval)ExpressionLambdaAggregatorFactory.this.initialCombineValue.get();
                columns = this.plan.getAnalysis().getRequiredBindingsList();
            }
            this.bindings = new ExpressionLambdaAggregatorInputBindings(ExpressionSelectors.createBindings(metricFactory, columns), ExpressionLambdaAggregatorFactory.this.accumulatorId, this.seed);
        }

        public Expr getExpression() {
            if (ExpressionLambdaAggregatorFactory.this.fields == null) {
                return this.plan.getExpression();
            }
            return this.plan.getAppliedFoldExpression(ExpressionLambdaAggregatorFactory.this.accumulatorId);
        }

        public ExprEval<?> getInitialValue() {
            return this.seed;
        }

        public ExpressionLambdaAggregatorInputBindings getBindings() {
            return this.bindings;
        }

        private ColumnInspector inspectorWithAccumulator(final ColumnInspector inspector) {
            return new ColumnInspector(){

                @Override
                @Nullable
                public ColumnCapabilities getColumnCapabilities(String column) {
                    if (ExpressionLambdaAggregatorFactory.this.accumulatorId.equals(column)) {
                        return ColumnCapabilitiesImpl.createDefault().setType(ExprType.toValueType((ExprType)((ExprEval)ExpressionLambdaAggregatorFactory.this.initialValue.get()).type()));
                    }
                    return inspector.getColumnCapabilities(column);
                }

                @Override
                @Nullable
                public ExprType getType(String name) {
                    if (ExpressionLambdaAggregatorFactory.this.accumulatorId.equals(name)) {
                        return ((ExprEval)ExpressionLambdaAggregatorFactory.this.initialValue.get()).type();
                    }
                    return inspector.getType(name);
                }
            };
        }
    }
}

