/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorInputBindings;

public class ExpressionLambdaBufferAggregator
implements BufferAggregator {
    private static final short NOT_AGGREGATED_BIT = 128;
    private static final short IS_AGGREGATED_MASK = 63;
    private final Expr lambda;
    private final ExprEval<?> initialValue;
    private final ExpressionLambdaAggregatorInputBindings bindings;
    private final int maxSizeBytes;
    private final boolean isNullUnlessAggregated;

    public ExpressionLambdaBufferAggregator(Expr lambda, ExprEval<?> initialValue, ExpressionLambdaAggregatorInputBindings bindings, boolean isNullUnlessAggregated, int maxSizeBytes) {
        this.lambda = lambda;
        this.initialValue = initialValue;
        this.bindings = bindings;
        this.isNullUnlessAggregated = isNullUnlessAggregated;
        this.maxSizeBytes = maxSizeBytes;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ExprEval.serialize((ByteBuffer)buf, (int)position, this.initialValue, (int)this.maxSizeBytes);
        if (this.isNullUnlessAggregated) {
            buf.put(position, (byte)(buf.get(position) | 0x80));
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        ExprEval acc = ExprEval.deserialize((ByteBuffer)buf, (int)(position + 1), (ExprType)ExpressionLambdaBufferAggregator.getType(buf, position));
        this.bindings.setAccumulator(acc);
        ExprEval newAcc = this.lambda.eval((Expr.ObjectBinding)this.bindings);
        ExprEval.serialize((ByteBuffer)buf, (int)position, (ExprEval)newAcc, (int)this.maxSizeBytes);
        buf.put(position, (byte)(buf.get(position) & 0x3F));
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        if (this.isNullUnlessAggregated && (buf.get(position) & 0x80) != 0) {
            return null;
        }
        return ExprEval.deserialize((ByteBuffer)buf, (int)(position + 1), (ExprType)ExpressionLambdaBufferAggregator.getType(buf, position)).value();
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)ExprEval.deserialize((ByteBuffer)buf, (int)(position + 1), (ExprType)ExpressionLambdaBufferAggregator.getType(buf, position)).asDouble();
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return ExprEval.deserialize((ByteBuffer)buf, (int)(position + 1), (ExprType)ExpressionLambdaBufferAggregator.getType(buf, position)).asDouble();
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return ExprEval.deserialize((ByteBuffer)buf, (int)(position + 1), (ExprType)ExpressionLambdaBufferAggregator.getType(buf, position)).asLong();
    }

    @Override
    public void close() {
    }

    private static ExprType getType(ByteBuffer buf, int position) {
        return ExprType.fromByte((byte)((byte)(buf.get(position) & 0x3F)));
    }
}

