/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.vector;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.types.StringCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.vector.CardinalityVectorProcessor;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class StringObjectCardinalityVectorProcessor
implements CardinalityVectorProcessor {
    private final VectorObjectSelector selector;

    public StringObjectCardinalityVectorProcessor(VectorObjectSelector selector) {
        this.selector = selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            Object[] vector = this.selector.getObjectVector();
            buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
            buf.position(position);
            HyperLogLogCollector collector = HyperLogLogCollector.makeCollector((ByteBuffer)buf);
            for (int i = startRow; i < endRow; ++i) {
                StringObjectCardinalityVectorProcessor.addObjectIfString(collector, vector[i]);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            Object[] vector = this.selector.getObjectVector();
            for (int i = 0; i < numRows; ++i) {
                Object obj = vector[rows != null ? rows[i] : i];
                if (!NullHandling.replaceWithDefault() && obj == null) continue;
                int position = positions[i] + positionOffset;
                buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
                buf.position(position);
                HyperLogLogCollector collector = HyperLogLogCollector.makeCollector((ByteBuffer)buf);
                StringObjectCardinalityVectorProcessor.addObjectIfString(collector, obj);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    private static void addObjectIfString(HyperLogLogCollector collector, @Nullable Object obj) {
        if (obj instanceof String) {
            StringCardinalityAggregatorColumnSelectorStrategy.addStringToCollector(collector, (String)obj);
        } else if (obj instanceof List) {
            for (String s : (List)obj) {
                StringCardinalityAggregatorColumnSelectorStrategy.addStringToCollector(collector, s);
            }
        } else {
            StringCardinalityAggregatorColumnSelectorStrategy.addStringToCollector(collector, null);
        }
    }
}

