/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ValueType;

public class ExtractionDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 1;
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final String outputName;
    private final ValueType outputType;

    @JsonCreator
    public ExtractionDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="outputType") ValueType outputType, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @Deprecated @JsonProperty(value="dimExtractionFn") ExtractionFn dimExtractionFn) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension must not be null");
        Preconditions.checkArgument((extractionFn != null || dimExtractionFn != null ? 1 : 0) != 0, (Object)"extractionFn must not be null");
        this.dimension = dimension;
        this.extractionFn = extractionFn != null ? extractionFn : dimExtractionFn;
        this.outputType = outputType == null ? ValueType.STRING : outputType;
        this.outputName = outputName == null ? dimension : outputName;
    }

    public ExtractionDimensionSpec(String dimension, String outputName, ExtractionFn extractionFn) {
        this(dimension, outputName, null, extractionFn, null);
    }

    public ExtractionDimensionSpec(String dimension, String outputName, ValueType outputType, ExtractionFn extractionFn) {
        this(dimension, outputName, outputType, extractionFn, null);
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    @JsonProperty
    public ValueType getOutputType() {
        return this.outputType;
    }

    @Override
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    @Override
    public boolean mustDecorate() {
        return false;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(1).appendString(this.dimension).appendCacheable((Cacheable)this.extractionFn).appendString(this.outputType.toString()).build();
    }

    @Override
    public boolean preservesOrdering() {
        return this.extractionFn.preservesOrdering();
    }

    @Override
    public DimensionSpec withDimension(String newDimension) {
        return new ExtractionDimensionSpec(newDimension, this.outputName, this.outputType, this.extractionFn);
    }

    public String toString() {
        return "ExtractionDimensionSpec{dimension='" + this.dimension + '\'' + ", extractionFn=" + this.extractionFn + ", outputName='" + this.outputName + '\'' + ", outputType='" + this.outputType + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtractionDimensionSpec that = (ExtractionDimensionSpec)o;
        if (this.extractionFn != null ? !this.extractionFn.equals(that.extractionFn) : that.extractionFn != null) {
            return false;
        }
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        if (this.outputName != null ? !this.outputName.equals(that.outputName) : that.outputName != null) {
            return false;
        }
        return !(this.outputType != null ? !this.outputType.equals((Object)that.outputType) : that.outputType != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        result = 31 * result + (this.outputName != null ? this.outputName.hashCode() : 0);
        result = 31 * result + (this.outputType != null ? this.outputType.hashCode() : 0);
        return result;
    }
}

