/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class TimestampExtractExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_extract";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", new Object[]{this.name()});
        }
        if (!args.get(1).isLiteral() || args.get(1).getLiteralValue() == null) {
            throw new IAE("Function[%s] unit arg must be literal", new Object[]{this.name()});
        }
        if (args.size() > 2 && !args.get(2).isLiteral()) {
            throw new IAE("Function[%s] timezone arg must be literal", new Object[]{this.name()});
        }
        Expr arg = args.get(0);
        Unit unit = Unit.valueOf(StringUtils.toUpperCase((String)((String)args.get(1).getLiteralValue())));
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)timeZone);
        class TimestampExtractExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ ISOChronology val$chronology;
            final /* synthetic */ Unit val$unit;
            final /* synthetic */ List val$args;

            TimestampExtractExpr(Expr arg) {
                this.val$chronology = iSOChronology;
                this.val$unit = unit;
                this.val$args = list;
                super(TimestampExtractExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                Object val = this.arg.eval(bindings).value();
                if (val == null) {
                    return ExprEval.of(null);
                }
                DateTime dateTime = new DateTime(val, (Chronology)this.val$chronology);
                long epoch = dateTime.getMillis() / 1000L;
                switch (this.val$unit) {
                    case EPOCH: {
                        return ExprEval.of((long)epoch);
                    }
                    case MICROSECOND: {
                        return ExprEval.of((long)(epoch / 1000L));
                    }
                    case MILLISECOND: {
                        return ExprEval.of((long)dateTime.millisOfSecond().get());
                    }
                    case SECOND: {
                        return ExprEval.of((long)dateTime.secondOfMinute().get());
                    }
                    case MINUTE: {
                        return ExprEval.of((long)dateTime.minuteOfHour().get());
                    }
                    case HOUR: {
                        return ExprEval.of((long)dateTime.hourOfDay().get());
                    }
                    case DAY: {
                        return ExprEval.of((long)dateTime.dayOfMonth().get());
                    }
                    case DOW: {
                        return ExprEval.of((long)dateTime.dayOfWeek().get());
                    }
                    case ISODOW: {
                        return ExprEval.of((long)dateTime.dayOfWeek().get());
                    }
                    case DOY: {
                        return ExprEval.of((long)dateTime.dayOfYear().get());
                    }
                    case WEEK: {
                        return ExprEval.of((long)dateTime.weekOfWeekyear().get());
                    }
                    case MONTH: {
                        return ExprEval.of((long)dateTime.monthOfYear().get());
                    }
                    case QUARTER: {
                        return ExprEval.of((long)((dateTime.monthOfYear().get() - 1) / 3 + 1));
                    }
                    case YEAR: {
                        return ExprEval.of((long)dateTime.year().get());
                    }
                    case ISOYEAR: {
                        return ExprEval.of((long)dateTime.year().get());
                    }
                    case DECADE: {
                        return ExprEval.of((long)(dateTime.year().get() / 10));
                    }
                    case CENTURY: {
                        return ExprEval.of((double)Math.ceil((double)dateTime.year().get() / 100.0));
                    }
                    case MILLENNIUM: {
                        return ExprEval.of((double)Math.ceil((double)dateTime.year().get() / 1000.0));
                    }
                }
                throw new ISE("Unhandled unit[%s]", new Object[]{this.val$unit});
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new TimestampExtractExpr(newArg));
            }

            @Nullable
            public ExprType getOutputType(Expr.InputBindingInspector inspector) {
                switch (this.val$unit) {
                    case CENTURY: 
                    case MILLENNIUM: {
                        return ExprType.DOUBLE;
                    }
                }
                return ExprType.LONG;
            }

            public String stringify() {
                if (this.val$args.size() > 2) {
                    return StringUtils.format((String)"%s(%s, %s, %s)", (Object[])new Object[]{TimestampExtractExprMacro.FN_NAME, this.arg.stringify(), ((Expr)this.val$args.get(1)).stringify(), ((Expr)this.val$args.get(2)).stringify()});
                }
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{TimestampExtractExprMacro.FN_NAME, this.arg.stringify(), ((Expr)this.val$args.get(1)).stringify()});
            }
        }
        return new TimestampExtractExpr(arg);
    }

    public static enum Unit {
        EPOCH,
        MICROSECOND,
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        DOW,
        ISODOW,
        DOY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR,
        ISOYEAR,
        DECADE,
        CENTURY,
        MILLENNIUM;

    }
}

