/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeRangeSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IntIteratorUtils;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class InDimFilter
extends AbstractOptimizableDimFilter
implements Filter {
    private final Set<String> values;
    private final String dimension;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;
    private final DruidPredicateFactory predicateFactory;
    @JsonIgnore
    private final Supplier<byte[]> cacheKeySupplier;

    @JsonCreator
    public InDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        this(dimension, values, extractionFn, filterTuning, null);
    }

    public InDimFilter(String dimension, Set<String> values) {
        this(dimension, values, null, null);
    }

    @VisibleForTesting
    public InDimFilter(String dimension, Collection<String> values, @Nullable ExtractionFn extractionFn) {
        this(dimension, (Set<String>)(values instanceof Set ? (Set<Object>)values : new HashSet<String>(values)), extractionFn, null, null);
    }

    private InDimFilter(String dimension, Set<String> values, @Nullable ExtractionFn extractionFn, @Nullable FilterTuning filterTuning, @Nullable DruidPredicateFactory predicateFactory) {
        Preconditions.checkNotNull(values, (Object)"values cannot be null");
        if (!NullHandling.sqlCompatible() && values.contains("")) {
            this.values = Sets.newHashSetWithExpectedSize((int)values.size());
            for (String v : values) {
                this.values.add(NullHandling.emptyToNullIfNeeded((String)v));
            }
        } else {
            this.values = values;
        }
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension cannot be null");
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.predicateFactory = predicateFactory != null ? predicateFactory : new InFilterDruidPredicateFactory(extractionFn, this.values);
        this.cacheKeySupplier = Suppliers.memoize(this::computeCacheKey);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public byte[] getCacheKey() {
        return (byte[])this.cacheKeySupplier.get();
    }

    @Override
    public DimFilter optimize() {
        InDimFilter inFilter = this.optimizeLookup();
        if (inFilter.values.isEmpty()) {
            return FalseDimFilter.instance();
        }
        if (inFilter.values.size() == 1) {
            return new SelectorDimFilter(inFilter.dimension, inFilter.values.iterator().next(), inFilter.getExtractionFn(), this.filterTuning);
        }
        return inFilter;
    }

    @Override
    public Filter toFilter() {
        return this;
    }

    @Override
    @Nullable
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        for (String value : this.values) {
            String valueEquivalent = NullHandling.nullToEmptyIfNeeded((String)value);
            if (valueEquivalent == null) {
                retSet.add(Range.lessThan((Comparable)((Object)"")));
                continue;
            }
            retSet.add(Range.singleton((Comparable)((Object)valueEquivalent)));
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (this.extractionFn == null) {
            BitmapIndex bitmapIndex = selector.getBitmapIndex(this.dimension);
            return bitmapResultFactory.unionDimensionValueBitmaps(InDimFilter.getBitmapIterable(this.values, bitmapIndex));
        }
        return Filters.matchPredicate(this.dimension, selector, bitmapResultFactory, this.predicateFactory.makeStringPredicate());
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        if (this.extractionFn == null) {
            BitmapIndex bitmapIndex = indexSelector.getBitmapIndex(this.dimension);
            return Filters.estimateSelectivity(bitmapIndex, IntIteratorUtils.toIntList(InDimFilter.getBitmapIndexIterable(this.values, bitmapIndex).iterator()), indexSelector.getNumRows());
        }
        return Filters.estimateSelectivity(this.dimension, indexSelector, this.predicateFactory.makeStringPredicate());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.predicateFactory);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", new Object[]{columnRewrites, this.dimension});
        }
        if (rewriteDimensionTo.equals(this.dimension)) {
            return this;
        }
        return new InDimFilter(rewriteDimensionTo, this.values, this.extractionFn, this.filterTuning, this.predicateFactory);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder builder = new DimFilter.DimFilterToStringBuilder();
        return builder.appendDimension(this.dimension, this.extractionFn).append(" IN (").append(Joiner.on((String)", ").join(Iterables.transform(this.values, StringUtils::nullToEmptyNonDruidDataString))).append(")").appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDimFilter that = (InDimFilter)o;
        return this.values.equals(that.values) && this.dimension.equals(that.dimension) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.dimension, this.extractionFn, this.filterTuning);
    }

    private byte[] computeCacheKey() {
        Collection<String> sortedValues;
        if (this.values instanceof SortedSet && InDimFilter.isNaturalOrder(((SortedSet)this.values).comparator())) {
            sortedValues = this.values;
        } else {
            ArrayList<String> sortedValuesList = new ArrayList<String>(this.values);
            sortedValuesList.sort((Comparator<String>)Comparators.naturalNullsFirst());
            sortedValues = sortedValuesList;
        }
        Hasher hasher = Hashing.sha256().newHasher();
        for (String v : sortedValues) {
            if (v == null) {
                hasher.putInt(-1);
                continue;
            }
            hasher.putInt(v.length());
            hasher.putString((CharSequence)v, StandardCharsets.UTF_8);
        }
        return new CacheKeyBuilder(9).appendString(this.dimension).appendByte((byte)-1).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).appendByte((byte)-1).appendByteArray(hasher.hash().asBytes()).build();
    }

    private InDimFilter optimizeLookup() {
        if (this.extractionFn instanceof LookupExtractionFn && ((LookupExtractionFn)this.extractionFn).isOptimize()) {
            LookupExtractionFn exFn = (LookupExtractionFn)this.extractionFn;
            LookupExtractor lookup = exFn.getLookup();
            HashSet<String> keys = new HashSet<String>();
            for (String value : this.values) {
                String convertedValue = NullHandling.emptyToNullIfNeeded((String)value);
                if (!exFn.isRetainMissingValue() && Objects.equals(convertedValue, exFn.getReplaceMissingValueWith())) {
                    return this;
                }
                keys.addAll(lookup.unapply(convertedValue));
                if (!exFn.isRetainMissingValue() || !NullHandling.isNullOrEquivalent((String)lookup.apply(convertedValue))) continue;
                keys.add(convertedValue);
            }
            if (keys.isEmpty()) {
                return this;
            }
            return new InDimFilter(this.dimension, keys, null, this.filterTuning);
        }
        return this;
    }

    private static <T> boolean isNaturalOrder(@Nullable Comparator<T> comparator) {
        return comparator == null || Comparators.naturalNullsFirst().equals(comparator);
    }

    private static Iterable<ImmutableBitmap> getBitmapIterable(Set<String> values, BitmapIndex bitmapIndex) {
        return Filters.bitmapsFromIndexes(InDimFilter.getBitmapIndexIterable(values, bitmapIndex), bitmapIndex);
    }

    private static IntIterable getBitmapIndexIterable(final Set<String> values, final BitmapIndex bitmapIndex) {
        return () -> new IntIterator(){
            final Iterator iterator;
            {
                this.iterator = values.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public int nextInt() {
                return bitmapIndex.getIndex((String)this.iterator.next());
            }
        };
    }

    private static Predicate<String> createStringPredicate(Set<String> values) {
        Preconditions.checkNotNull(values, (Object)"values");
        try {
            values.contains(null);
            return values::contains;
        }
        catch (NullPointerException nullPointerException) {
            return value -> value != null && values.contains(value);
        }
    }

    private static DruidLongPredicate createLongPredicate(Set<String> values) {
        LongArrayList longs = new LongArrayList(values.size());
        for (String value : values) {
            Long longValue = DimensionHandlerUtils.convertObjectToLong(value);
            if (longValue == null) continue;
            longs.add(longValue.longValue());
        }
        LongOpenHashSet longHashSet = new LongOpenHashSet((LongCollection)longs);
        return arg_0 -> ((LongOpenHashSet)longHashSet).contains(arg_0);
    }

    private static DruidFloatPredicate createFloatPredicate(Set<String> values) {
        IntArrayList floatBits = new IntArrayList(values.size());
        for (String value : values) {
            Float floatValue = DimensionHandlerUtils.convertObjectToFloat(value);
            if (floatValue == null) continue;
            floatBits.add(Float.floatToIntBits(floatValue.floatValue()));
        }
        IntOpenHashSet floatBitsHashSet = new IntOpenHashSet((IntCollection)floatBits);
        return input -> floatBitsHashSet.contains(Float.floatToIntBits(input));
    }

    private static DruidDoublePredicate createDoublePredicate(Set<String> values) {
        LongArrayList doubleBits = new LongArrayList(values.size());
        for (String value : values) {
            Double doubleValue = DimensionHandlerUtils.convertObjectToDouble(value);
            if (doubleValue == null) continue;
            doubleBits.add(Double.doubleToLongBits(doubleValue));
        }
        LongOpenHashSet doubleBitsHashSet = new LongOpenHashSet((LongCollection)doubleBits);
        return input -> doubleBitsHashSet.contains(Double.doubleToLongBits(input));
    }

    @VisibleForTesting
    public static class InFilterDruidPredicateFactory
    implements DruidPredicateFactory {
        private final ExtractionFn extractionFn;
        private final Set<String> values;
        private final Supplier<Predicate<String>> stringPredicateSupplier;
        private final Supplier<DruidLongPredicate> longPredicateSupplier;
        private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
        private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

        InFilterDruidPredicateFactory(ExtractionFn extractionFn, Set<String> values) {
            this.extractionFn = extractionFn;
            this.values = values;
            this.stringPredicateSupplier = Suppliers.memoize(() -> InDimFilter.createStringPredicate(values));
            this.longPredicateSupplier = Suppliers.memoize(() -> InDimFilter.createLongPredicate(values));
            this.floatPredicateSupplier = Suppliers.memoize(() -> InDimFilter.createFloatPredicate(values));
            this.doublePredicateSupplier = Suppliers.memoize(() -> InDimFilter.createDoublePredicate(values));
        }

        @Override
        public Predicate<String> makeStringPredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply((String)input));
            }
            return (Predicate)this.stringPredicateSupplier.get();
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply(input));
            }
            return (DruidLongPredicate)this.longPredicateSupplier.get();
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply(Float.valueOf(input)));
            }
            return (DruidFloatPredicate)this.floatPredicateSupplier.get();
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply(input));
            }
            return (DruidDoublePredicate)this.doublePredicateSupplier.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InFilterDruidPredicateFactory that = (InFilterDruidPredicateFactory)o;
            return Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.extractionFn, this.values);
        }
    }
}

