/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.druid.query.groupby.resource.GroupByQueryResource;

public class GroupByRowProcessor {
    private GroupByRowProcessor() {
    }

    public static ResultSupplier process(final GroupByQuery query, GroupByQuery subquery, Sequence<ResultRow> rows, GroupByQueryConfig config, final GroupByQueryResource resource, ObjectMapper spillMapper, String processingTmpDir, int mergeBufferSize) {
        final Closer closeOnExit = Closer.create();
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        File temporaryStorageDirectory = new File(processingTmpDir, StringUtils.format((String)"druid-groupBy-%s_%s", (Object[])new Object[]{UUID.randomUUID(), query.getId()}));
        LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
        closeOnExit.register((Closeable)temporaryStorage);
        Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<AggregateResult, ResultRow>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, subquery, querySpecificConfig, new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                ResourceHolder<ByteBuffer> mergeBufferHolder = resource.getMergeBuffer();
                closeOnExit.register(mergeBufferHolder);
                return (ByteBuffer)mergeBufferHolder.get();
            }
        }, temporaryStorage, spillMapper, mergeBufferSize);
        final Grouper grouper = (Grouper)pair.lhs;
        Accumulator accumulator = (Accumulator)pair.rhs;
        closeOnExit.register((Closeable)grouper);
        AggregateResult retVal = (AggregateResult)rows.accumulate((Object)AggregateResult.ok(), accumulator);
        if (!retVal.isOk()) {
            throw new ResourceLimitExceededException(retVal.getReason());
        }
        return new ResultSupplier(){

            @Override
            public Sequence<ResultRow> results(@Nullable List<DimensionSpec> dimensionsToInclude) {
                return GroupByRowProcessor.getRowsFromGrouper(query, grouper, dimensionsToInclude);
            }

            @Override
            public void close() throws IOException {
                closeOnExit.close();
            }
        };
    }

    private static Sequence<ResultRow> getRowsFromGrouper(final GroupByQuery query, final Grouper<RowBasedGrouperHelper.RowBasedKey> grouper, final @Nullable List<DimensionSpec> dimensionsToInclude) {
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ResultRow, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, ResultRow>>(){

            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, ResultRow> make() {
                return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, dimensionsToInclude, () -> {});
            }

            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, ResultRow> iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    public static interface ResultSupplier
    extends Closeable {
        public Sequence<ResultRow> results(@Nullable List<DimensionSpec> var1);
    }
}

