/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryLimitRowIterator;
import org.apache.druid.query.scan.ScanQueryOffsetSequence;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class ScanQueryQueryToolChest
extends QueryToolChest<ScanResultValue, ScanQuery> {
    private static final TypeReference<ScanResultValue> TYPE_REFERENCE = new TypeReference<ScanResultValue>(){};
    private final ScanQueryConfig scanQueryConfig;
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public ScanQueryQueryToolChest(ScanQueryConfig scanQueryConfig, GenericQueryMetricsFactory queryMetricsFactory) {
        this.scanQueryConfig = scanQueryConfig;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<ScanResultValue> mergeResults(final QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> {
            long newLimit;
            ScanQuery originalQuery = (ScanQuery)queryPlus.getQuery();
            if (!originalQuery.isLimited()) {
                newLimit = Long.MAX_VALUE;
            } else {
                if (originalQuery.getScanRowsLimit() > Long.MAX_VALUE - originalQuery.getScanRowsOffset()) {
                    throw new ISE("Cannot apply limit[%d] with offset[%d] due to overflow", new Object[]{originalQuery.getScanRowsLimit(), originalQuery.getScanRowsOffset()});
                }
                newLimit = originalQuery.getScanRowsLimit() + originalQuery.getScanRowsOffset();
            }
            final ScanQuery queryToRun = originalQuery.withNonNullLegacy(this.scanQueryConfig).withOffset(0L).withLimit(newLimit);
            BaseSequence results = !queryToRun.isLimited() ? runner.run(queryPlus.withQuery(queryToRun), responseContext) : new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ScanResultValue, ScanQueryLimitRowIterator>(){

                public ScanQueryLimitRowIterator make() {
                    return new ScanQueryLimitRowIterator(runner, queryPlus.withQuery(queryToRun), responseContext);
                }

                public void cleanup(ScanQueryLimitRowIterator iterFromMake) {
                    CloseQuietly.close((Closeable)((Object)iterFromMake));
                }
            });
            if (originalQuery.getScanRowsOffset() > 0L) {
                return new ScanQueryOffsetSequence((Sequence<ScanResultValue>)results, originalQuery.getScanRowsOffset());
            }
            return results;
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(ScanQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<ScanResultValue, ScanResultValue> makePreComputeManipulatorFn(ScanQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<ScanResultValue> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<ScanResultValue> preMergeQueryDecoration(QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> runner.run(queryPlus, responseContext);
    }

    @Override
    public RowSignature resultArraySignature(ScanQuery query) {
        if (query.getColumns() == null || query.getColumns().isEmpty()) {
            return RowSignature.empty();
        }
        RowSignature.Builder builder = RowSignature.builder();
        if (query.withNonNullLegacy(this.scanQueryConfig).isLegacy().booleanValue()) {
            builder.add("timestamp", null);
        }
        for (String columnName : query.getColumns()) {
            VirtualColumn virtualColumn = query.getVirtualColumns().getVirtualColumn(columnName);
            ValueType columnType = virtualColumn != null ? virtualColumn.capabilities(columnName).getType() : null;
            builder.add(columnName, columnType);
        }
        return builder.build();
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(ScanQuery query, Sequence<ScanResultValue> resultSequence) {
        Function mapper;
        List<String> fields = this.resultArraySignature(query).getColumnNames();
        switch (query.getResultFormat()) {
            case RESULT_FORMAT_LIST: {
                mapper = row -> {
                    Object[] rowArray = new Object[fields.size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        rowArray[i] = row.get(fields.get(i));
                    }
                    return rowArray;
                };
                break;
            }
            case RESULT_FORMAT_COMPACTED_LIST: {
                mapper = row -> {
                    if (row.size() == fields.size()) {
                        return row.toArray();
                    }
                    if (fields.isEmpty()) {
                        return new Object[0];
                    }
                    throw new ISE("Mismatch in expected[%d] vs actual[%s] field count", new Object[]{fields.size(), row.size()});
                };
                break;
            }
            default: {
                throw new UOE("Unsupported resultFormat for array-based results: %s", new Object[]{query.getResultFormat()});
            }
        }
        return resultSequence.flatMap(result -> {
            List rows = (List)result.getEvents();
            Iterable arrays = Iterables.transform((Iterable)rows, (Function)mapper);
            return Sequences.simple((Iterable)arrays);
        });
    }
}

