/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.topn.AggregateTopNMetricFirstAlgorithm;
import org.apache.druid.query.topn.HeapBasedTopNAlgorithm;
import org.apache.druid.query.topn.PooledTopNAlgorithm;
import org.apache.druid.query.topn.TimeExtractionTopNAlgorithm;
import org.apache.druid.query.topn.TopNAlgorithm;
import org.apache.druid.query.topn.TopNAlgorithmSelector;
import org.apache.druid.query.topn.TopNMapFn;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.SegmentMissingException;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.Interval;

public class TopNQueryEngine {
    private final NonBlockingPool<ByteBuffer> bufferPool;

    public TopNQueryEngine(NonBlockingPool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    public Sequence<Result<TopNResultValue>> query(TopNQuery query, StorageAdapter adapter, @Nullable TopNQueryMetrics queryMetrics) {
        if (adapter == null) {
            throw new SegmentMissingException("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> queryIntervals = query.getQuerySegmentSpec().getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        Granularity granularity = query.getGranularity();
        TopNMapFn mapFn = this.getMapFn(query, adapter, queryMetrics);
        Preconditions.checkArgument((queryIntervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{queryIntervals});
        return Sequences.filter((Sequence)Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), query.getVirtualColumns(), granularity, query.isDescending(), queryMetrics), input -> {
            if (queryMetrics != null) {
                queryMetrics.cursor((Cursor)input);
            }
            return mapFn.apply((Cursor)input, queryMetrics);
        }), (Predicate)Predicates.notNull());
    }

    private TopNMapFn getMapFn(TopNQuery query, StorageAdapter adapter, @Nullable TopNQueryMetrics queryMetrics) {
        String dimension = query.getDimensionSpec().getDimension();
        int cardinality = adapter.getDimensionCardinality(dimension);
        if (queryMetrics != null) {
            queryMetrics.dimensionCardinality(cardinality);
        }
        int numBytesPerRecord = 0;
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            numBytesPerRecord += aggregatorFactory.getMaxIntermediateSizeWithNulls();
        }
        TopNAlgorithmSelector selector = new TopNAlgorithmSelector(cardinality, numBytesPerRecord);
        query.initTopNAlgorithmSelector(selector);
        ColumnCapabilities columnCapabilities = query.getVirtualColumns().getColumnCapabilitiesWithFallback(adapter, dimension);
        TopNAlgorithm<Aggregator[][], TopNParams> topNAlgorithm = TopNQueryEngine.canUsePooledAlgorithm(selector, query, columnCapabilities) ? (selector.isAggregateAllMetrics() ? new PooledTopNAlgorithm(adapter, query, this.bufferPool) : (selector.isAggregateTopNMetricFirst() || query.getContextBoolean("doAggregateTopNMetricFirst", false) ? new AggregateTopNMetricFirstAlgorithm(adapter, query, this.bufferPool) : new PooledTopNAlgorithm(adapter, query, this.bufferPool))) : (selector.isHasExtractionFn() && dimension.equals("__time") ? new TimeExtractionTopNAlgorithm(adapter, query) : new HeapBasedTopNAlgorithm(adapter, query));
        if (queryMetrics != null) {
            queryMetrics.algorithm(topNAlgorithm);
        }
        return new TopNMapFn(query, topNAlgorithm);
    }

    private static boolean canUsePooledAlgorithm(TopNAlgorithmSelector selector, TopNQuery query, ColumnCapabilities capabilities) {
        if (selector.isHasExtractionFn()) {
            return false;
        }
        if (query.getDimensionSpec().getOutputType() != ValueType.STRING) {
            return false;
        }
        if (capabilities != null && capabilities.getType() == ValueType.STRING) {
            return capabilities.isDictionaryEncoded().isTrue() && capabilities.areDictionaryValuesUnique().isTrue();
        }
        return false;
    }

    public static boolean canApplyExtractionInPost(TopNQuery query) {
        return query.getDimensionSpec() != null && query.getDimensionSpec().getExtractionFn() != null && ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)query.getDimensionSpec().getExtractionFn().getExtractionType()) && query.getTopNMetricSpec().canBeOptimizedUnordered();
    }
}

