/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.RowOffsetMatcherFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class AndFilter
implements BooleanFilter {
    private static final Joiner AND_JOINER = Joiner.on((String)" && ");
    private final LinkedHashSet<Filter> filters;

    public AndFilter(LinkedHashSet<Filter> filters) {
        Preconditions.checkArgument((filters.size() > 0 ? 1 : 0) != 0, (Object)"Can't construct empty AndFilter");
        this.filters = filters;
    }

    @VisibleForTesting
    public AndFilter(List<Filter> filters) {
        this(new LinkedHashSet<Filter>(filters));
    }

    public static <T> ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, List<Filter> filters) {
        return bitmapResultFactory.toImmutableBitmap(AndFilter.getBitmapResult(selector, bitmapResultFactory, filters));
    }

    private static <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, Collection<Filter> filters) {
        if (filters.size() == 1) {
            return ((Filter)Iterables.getOnlyElement(filters)).getBitmapResult(selector, bitmapResultFactory);
        }
        ArrayList bitmapResults = Lists.newArrayListWithCapacity((int)filters.size());
        for (Filter filter : filters) {
            Preconditions.checkArgument((boolean)filter.supportsBitmapIndex(selector), (String)"Filter[%s] does not support bitmap index", (Object[])new Object[]{filter});
            T bitmapResult = filter.getBitmapResult(selector, bitmapResultFactory);
            if (bitmapResultFactory.isEmpty(bitmapResult)) {
                return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
            }
            bitmapResults.add(bitmapResult);
        }
        return bitmapResultFactory.intersection(bitmapResults);
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return AndFilter.getBitmapResult(selector, bitmapResultFactory, this.filters);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeMatcher(factory);
        }
        return AndFilter.makeMatcher(matchers);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        VectorValueMatcher[] matchers = new VectorValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeVectorMatcher(factory);
        }
        return AndFilter.makeVectorMatcher(matchers);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return this.filters.stream().allMatch(filter -> filter.canVectorizeMatcher(inspector));
    }

    @Override
    public ValueMatcher makeMatcher(BitmapIndexSelector selector, ColumnSelectorFactory columnSelectorFactory, RowOffsetMatcherFactory rowOffsetMatcherFactory) {
        ArrayList<ValueMatcher> matchers = new ArrayList<ValueMatcher>();
        ArrayList<ImmutableBitmap> bitmaps = new ArrayList<ImmutableBitmap>();
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) {
                bitmaps.add(filter.getBitmapIndex(selector));
                continue;
            }
            ValueMatcher matcher = filter.makeMatcher(columnSelectorFactory);
            matchers.add(matcher);
        }
        if (bitmaps.size() > 0) {
            ImmutableBitmap combinedBitmap = selector.getBitmapFactory().intersection(bitmaps);
            ValueMatcher offsetMatcher = rowOffsetMatcherFactory.makeRowOffsetMatcher(combinedBitmap);
            matchers.add(0, offsetMatcher);
        }
        return AndFilter.makeMatcher(matchers.toArray(BooleanFilter.EMPTY_VALUE_MATCHER_ARRAY));
    }

    @Override
    public LinkedHashSet<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        double selectivity = 1.0;
        for (Filter filter : this.filters) {
            selectivity *= filter.estimateSelectivity(indexSelector);
        }
        return selectivity;
    }

    public String toString() {
        return StringUtils.format((String)"(%s)", (Object[])new Object[]{AND_JOINER.join(this.filters)});
    }

    private static ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (matcher.matches()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("firstBaseMatcher", baseMatchers[0]);
                inspector.visit("secondBaseMatcher", baseMatchers[1]);
            }
        };
    }

    private static VectorValueMatcher makeVectorMatcher(final VectorValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new BaseVectorValueMatcher(baseMatchers[0]){

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                ReadableVectorMatch match = mask;
                for (VectorValueMatcher matcher : baseMatchers) {
                    if (match.isAllFalse()) break;
                    match = matcher.match(match);
                }
                assert (match.isValid(mask));
                return match;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndFilter andFilter = (AndFilter)o;
        return Objects.equals(this.getFilters(), andFilter.getFilters());
    }

    public int hashCode() {
        return Objects.hash(this.getFilters());
    }
}

