/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class BoundFilter
implements Filter {
    private final BoundDimFilter boundDimFilter;
    private final ExtractionFn extractionFn;
    private final FilterTuning filterTuning;

    public BoundFilter(BoundDimFilter boundDimFilter) {
        this.boundDimFilter = boundDimFilter;
        this.extractionFn = boundDimFilter.getExtractionFn();
        this.filterTuning = boundDimFilter.getFilterTuning();
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (this.supportShortCircuit()) {
            BitmapIndex bitmapIndex = selector.getBitmapIndex(this.boundDimFilter.getDimension());
            if (bitmapIndex == null || bitmapIndex.getCardinality() == 0) {
                if (this.doesMatchNull()) {
                    return bitmapResultFactory.wrapAllTrue(Filters.allTrue(selector));
                }
                return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
            }
            return bitmapResultFactory.unionDimensionValueBitmaps(BoundFilter.getBitmapIterator(this.boundDimFilter, bitmapIndex));
        }
        return Filters.matchPredicate(this.boundDimFilter.getDimension(), selector, bitmapResultFactory, this.getPredicateFactory().makeStringPredicate());
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        if (this.supportShortCircuit()) {
            BitmapIndex bitmapIndex = indexSelector.getBitmapIndex(this.boundDimFilter.getDimension());
            if (bitmapIndex == null || bitmapIndex.getCardinality() == 0) {
                return this.doesMatchNull() ? 1.0 : 0.0;
            }
            return Filters.estimateSelectivity(bitmapIndex, BoundFilter.getBitmapIndexList(this.boundDimFilter, bitmapIndex), indexSelector.getNumRows());
        }
        return Filters.estimateSelectivity(this.boundDimFilter.getDimension(), indexSelector, this.getPredicateFactory().makeStringPredicate());
    }

    private boolean supportShortCircuit() {
        return this.boundDimFilter.getOrdering().equals(StringComparators.LEXICOGRAPHIC) && this.extractionFn == null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.boundDimFilter.getDimension(), this.getPredicateFactory());
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.boundDimFilter.getDimension(), VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.getPredicateFactory());
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.boundDimFilter.getDimension()) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.boundDimFilter.getDimension(), columnSelector, indexSelector);
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.boundDimFilter.getRequiredColumns();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.boundDimFilter.getDimension());
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", new Object[]{columnRewrites, this.boundDimFilter.getDimension()});
        }
        BoundDimFilter newDimFilter = new BoundDimFilter(rewriteDimensionTo, this.boundDimFilter.getLower(), this.boundDimFilter.getUpper(), this.boundDimFilter.isLowerStrict(), this.boundDimFilter.isUpperStrict(), null, this.boundDimFilter.getExtractionFn(), this.boundDimFilter.getOrdering());
        return new BoundFilter(newDimFilter);
    }

    private static Pair<Integer, Integer> getStartEndIndexes(BoundDimFilter boundDimFilter, BitmapIndex bitmapIndex) {
        int found;
        int startIndex = !boundDimFilter.hasLowerBound() ? 0 : ((found = bitmapIndex.getIndex(NullHandling.emptyToNullIfNeeded((String)boundDimFilter.getLower()))) >= 0 ? (boundDimFilter.isLowerStrict() ? found + 1 : found) : -(found + 1));
        int endIndex = !boundDimFilter.hasUpperBound() ? bitmapIndex.getCardinality() : ((found = bitmapIndex.getIndex(NullHandling.emptyToNullIfNeeded((String)boundDimFilter.getUpper()))) >= 0 ? (boundDimFilter.isUpperStrict() ? found : found + 1) : -(found + 1));
        endIndex = startIndex > endIndex ? startIndex : endIndex;
        return new Pair((Object)startIndex, (Object)endIndex);
    }

    private static Iterable<ImmutableBitmap> getBitmapIterator(BoundDimFilter boundDimFilter, BitmapIndex bitmapIndex) {
        return Filters.bitmapsFromIndexes((IntIterable)BoundFilter.getBitmapIndexList(boundDimFilter, bitmapIndex), bitmapIndex);
    }

    private static IntList getBitmapIndexList(BoundDimFilter boundDimFilter, BitmapIndex bitmapIndex) {
        Pair<Integer, Integer> indexes = BoundFilter.getStartEndIndexes(boundDimFilter, bitmapIndex);
        int startIndex = (Integer)indexes.lhs;
        int endIndex = (Integer)indexes.rhs;
        return IntListUtils.fromTo(startIndex, endIndex);
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new BoundDimFilterDruidPredicateFactory(this.extractionFn, this.boundDimFilter);
    }

    private boolean doesMatchNull() {
        return BoundFilter.doesMatch(null, this.boundDimFilter);
    }

    private static boolean doesMatch(String input, BoundDimFilter boundDimFilter) {
        if (input == null) {
            return (!boundDimFilter.hasLowerBound() || NullHandling.isNullOrEquivalent((String)boundDimFilter.getLower()) && !boundDimFilter.isLowerStrict()) && (!boundDimFilter.hasUpperBound() || !NullHandling.isNullOrEquivalent((String)boundDimFilter.getUpper()) || !boundDimFilter.isUpperStrict());
        }
        int lowerComparing = 1;
        int upperComparing = 1;
        if (boundDimFilter.hasLowerBound()) {
            lowerComparing = boundDimFilter.getOrdering().compare(input, boundDimFilter.getLower());
        }
        if (boundDimFilter.hasUpperBound()) {
            upperComparing = boundDimFilter.getOrdering().compare(boundDimFilter.getUpper(), input);
        }
        if (boundDimFilter.isLowerStrict() && boundDimFilter.isUpperStrict()) {
            return lowerComparing > 0 && upperComparing > 0;
        }
        if (boundDimFilter.isLowerStrict()) {
            return lowerComparing > 0 && upperComparing >= 0;
        }
        if (boundDimFilter.isUpperStrict()) {
            return lowerComparing >= 0 && upperComparing > 0;
        }
        return lowerComparing >= 0 && upperComparing >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundFilter that = (BoundFilter)o;
        return Objects.equals(this.boundDimFilter, that.boundDimFilter) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.boundDimFilter, this.extractionFn, this.filterTuning);
    }

    public String toString() {
        return this.boundDimFilter.toString();
    }

    @VisibleForTesting
    static class BoundDimFilterDruidPredicateFactory
    implements DruidPredicateFactory {
        private final ExtractionFn extractionFn;
        private final BoundDimFilter boundDimFilter;
        private final Supplier<DruidLongPredicate> longPredicateSupplier;
        private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
        private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

        BoundDimFilterDruidPredicateFactory(ExtractionFn extractionFn, BoundDimFilter boundDimFilter) {
            this.extractionFn = extractionFn;
            this.boundDimFilter = boundDimFilter;
            this.longPredicateSupplier = boundDimFilter.getLongPredicateSupplier();
            this.floatPredicateSupplier = boundDimFilter.getFloatPredicateSupplier();
            this.doublePredicateSupplier = boundDimFilter.getDoublePredicateSupplier();
        }

        @Override
        public Predicate<String> makeStringPredicate() {
            if (this.extractionFn != null) {
                return input -> BoundFilter.doesMatch(this.extractionFn.apply((String)input), this.boundDimFilter);
            }
            return input -> BoundFilter.doesMatch(input, this.boundDimFilter);
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            if (this.extractionFn != null) {
                return input -> BoundFilter.doesMatch(this.extractionFn.apply(input), this.boundDimFilter);
            }
            if (this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                return (DruidLongPredicate)this.longPredicateSupplier.get();
            }
            return input -> BoundFilter.doesMatch(String.valueOf(input), this.boundDimFilter);
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            if (this.extractionFn != null) {
                return input -> BoundFilter.doesMatch(this.extractionFn.apply(Float.valueOf(input)), this.boundDimFilter);
            }
            if (this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                return (DruidFloatPredicate)this.floatPredicateSupplier.get();
            }
            return input -> BoundFilter.doesMatch(String.valueOf(input), this.boundDimFilter);
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            if (this.extractionFn != null) {
                return input -> BoundFilter.doesMatch(this.extractionFn.apply(input), this.boundDimFilter);
            }
            if (this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                return (DruidDoublePredicate)this.doublePredicateSupplier.get();
            }
            return input -> BoundFilter.doesMatch(String.valueOf(input), this.boundDimFilter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundDimFilterDruidPredicateFactory that = (BoundDimFilterDruidPredicateFactory)o;
            return Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.boundDimFilter, that.boundDimFilter);
        }

        public int hashCode() {
            return Objects.hash(this.extractionFn, this.boundDimFilter);
        }
    }
}

