/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class LikeFilter
implements Filter {
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final LikeDimFilter.LikeMatcher likeMatcher;
    private final FilterTuning filterTuning;

    public LikeFilter(String dimension, ExtractionFn extractionFn, LikeDimFilter.LikeMatcher likeMatcher, FilterTuning filterTuning) {
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.likeMatcher = likeMatcher;
        this.filterTuning = filterTuning;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapIterable(selector));
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector selector) {
        return Filters.estimateSelectivity(this.getBitmapIterable(selector).iterator(), selector.getNumRows());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.likeMatcher.predicateFactory(this.extractionFn));
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.likeMatcher.predicateFactory(this.extractionFn));
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", new Object[]{columnRewrites, this.dimension});
        }
        return new LikeFilter(rewriteDimensionTo, this.extractionFn, this.likeMatcher, this.filterTuning);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterable<ImmutableBitmap> getBitmapIterable(BitmapIndexSelector selector) {
        if (this.isSimpleEquals()) {
            return ImmutableList.of((Object)selector.getBitmapIndex(this.dimension, NullHandling.emptyToNullIfNeeded((String)this.likeMatcher.getPrefix())));
        }
        if (!this.isSimplePrefix()) return Filters.matchPredicateNoUnion(this.dimension, selector, this.likeMatcher.predicateFactory(this.extractionFn).makeStringPredicate());
        BitmapIndex bitmapIndex = selector.getBitmapIndex(this.dimension);
        if (bitmapIndex == null) {
            ImmutableBitmap immutableBitmap;
            if (this.likeMatcher.matches(null)) {
                immutableBitmap = Filters.allTrue(selector);
                return ImmutableList.of((Object)immutableBitmap);
            }
            immutableBitmap = Filters.allFalse(selector);
            return ImmutableList.of((Object)immutableBitmap);
        }
        try (CloseableIndexed<String> dimValues = selector.getDimensionValues(this.dimension);){
            Iterable<ImmutableBitmap> iterable = Filters.bitmapsFromIndexes(this.getDimValueIndexIterableForPrefixMatch(bitmapIndex, dimValues), bitmapIndex);
            return iterable;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isSimpleEquals() {
        return this.extractionFn == null && this.likeMatcher.getSuffixMatch() == LikeDimFilter.LikeMatcher.SuffixMatch.MATCH_EMPTY;
    }

    private boolean isSimplePrefix() {
        return this.extractionFn == null && !this.likeMatcher.getPrefix().isEmpty();
    }

    private IntIterable getDimValueIndexIterableForPrefixMatch(BitmapIndex bitmapIndex, final Indexed<String> dimValues) {
        int endIndex;
        int startIndex;
        String lower = NullHandling.nullToEmptyIfNeeded((String)this.likeMatcher.getPrefix());
        String upper = NullHandling.nullToEmptyIfNeeded((String)this.likeMatcher.getPrefix()) + '\uffff';
        if (lower == null) {
            startIndex = bitmapIndex.getIndex(null);
            endIndex = startIndex + 1;
        } else {
            int lowerFound = bitmapIndex.getIndex(lower);
            startIndex = lowerFound >= 0 ? lowerFound : -(lowerFound + 1);
            int upperFound = bitmapIndex.getIndex(upper);
            endIndex = upperFound >= 0 ? upperFound + 1 : -(upperFound + 1);
        }
        return new IntIterable(){

            public IntIterator iterator() {
                return new IntIterator(){
                    int currIndex;
                    int found;
                    {
                        this.currIndex = startIndex;
                        this.found = this.findNext();
                    }

                    private int findNext() {
                        while (this.currIndex < endIndex && !LikeFilter.this.likeMatcher.matchesSuffixOnly(dimValues, this.currIndex)) {
                            ++this.currIndex;
                        }
                        if (this.currIndex < endIndex) {
                            return this.currIndex++;
                        }
                        return -1;
                    }

                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    public int nextInt() {
                        int cur = this.found;
                        if (cur == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNext();
                        return cur;
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikeFilter that = (LikeFilter)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.likeMatcher, that.likeMatcher) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.extractionFn, this.likeMatcher, this.filterTuning);
    }
}

