/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter.cnf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.OrFilter;

public class HiveCnfHelper {
    public static Filter pushDownNot(Filter current) {
        ArrayList<Filter> children;
        if (current instanceof NotFilter) {
            Filter child = ((NotFilter)current).getBaseFilter();
            if (child instanceof NotFilter) {
                return HiveCnfHelper.pushDownNot(((NotFilter)child).getBaseFilter());
            }
            if (child instanceof AndFilter) {
                ArrayList<Filter> children2 = new ArrayList<Filter>();
                for (Filter grandChild : ((AndFilter)child).getFilters()) {
                    children2.add(HiveCnfHelper.pushDownNot(new NotFilter(grandChild)));
                }
                return Filters.or(children2);
            }
            if (child instanceof OrFilter) {
                ArrayList<Filter> children3 = new ArrayList<Filter>();
                for (Filter grandChild : ((OrFilter)child).getFilters()) {
                    children3.add(HiveCnfHelper.pushDownNot(new NotFilter(grandChild)));
                }
                return Filters.and(children3);
            }
        }
        if (current instanceof AndFilter) {
            children = new ArrayList<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(HiveCnfHelper.pushDownNot(child));
            }
            return Filters.and(children);
        }
        if (current instanceof OrFilter) {
            children = new ArrayList();
            for (Filter child : ((OrFilter)current).getFilters()) {
                children.add(HiveCnfHelper.pushDownNot(child));
            }
            return Filters.or(children);
        }
        return current;
    }

    public static Filter convertToCnf(Filter current) {
        if (current instanceof NotFilter) {
            return new NotFilter(HiveCnfHelper.convertToCnf(((NotFilter)current).getBaseFilter()));
        }
        if (current instanceof AndFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(HiveCnfHelper.convertToCnf(child));
            }
            return Filters.and(children);
        }
        if (current instanceof OrFilter) {
            ArrayList<Filter> nonAndList = new ArrayList<Filter>();
            ArrayList<Filter> andList = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)current).getFilters()) {
                if (child instanceof AndFilter) {
                    andList.add(child);
                    continue;
                }
                if (child instanceof OrFilter) {
                    nonAndList.addAll(((OrFilter)child).getFilters());
                    continue;
                }
                nonAndList.add(child);
            }
            if (!andList.isEmpty()) {
                ArrayList<Filter> result = new ArrayList<Filter>();
                HiveCnfHelper.generateAllCombinations(result, andList, nonAndList);
                return Filters.and(result);
            }
        }
        return current;
    }

    public static Filter flatten(Filter root) {
        if (root instanceof BooleanFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>(((BooleanFilter)root).getFilters());
            for (int i = 0; i < children.size(); ++i) {
                Filter child = HiveCnfHelper.flatten((Filter)children.get(i));
                if (child.getClass() == root.getClass() && !(child instanceof NotFilter)) {
                    boolean first = true;
                    ArrayList<Filter> grandKids = new ArrayList<Filter>(((BooleanFilter)child).getFilters());
                    for (Filter grandkid : grandKids) {
                        if (first) {
                            first = false;
                            children.set(i, grandkid);
                            continue;
                        }
                        children.add(++i, grandkid);
                    }
                    continue;
                }
                children.set(i, child);
            }
            if (children.size() == 1 && (root instanceof AndFilter || root instanceof OrFilter)) {
                return (Filter)children.get(0);
            }
            if (root instanceof AndFilter) {
                return new AndFilter(children);
            }
            if (root instanceof OrFilter) {
                return new OrFilter(children);
            }
        }
        return root;
    }

    private static void generateAllCombinations(List<Filter> result, List<Filter> andList, List<Filter> nonAndList) {
        ArrayList<Filter> children = new ArrayList<Filter>(((AndFilter)andList.get(0)).getFilters());
        if (result.isEmpty()) {
            for (Filter child : children) {
                ArrayList<Filter> a = new ArrayList<Filter>(nonAndList);
                a.add(child);
                result.add(HiveCnfHelper.idempotentOr(Filters.or(a)));
            }
        } else {
            ArrayList<Filter> work = new ArrayList<Filter>(result);
            result.clear();
            for (Filter child : children) {
                for (Filter or : work) {
                    ArrayList<Filter> a = new ArrayList<Filter>(((OrFilter)or).getFilters());
                    a.add(child);
                    result.add(HiveCnfHelper.idempotentOr(Filters.or(a)));
                }
            }
        }
        if (andList.size() > 1) {
            HiveCnfHelper.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
        }
    }

    private static OrFilter idempotentOr(Filter filter) {
        return filter instanceof OrFilter ? (OrFilter)filter : new OrFilter(Collections.singletonList(filter));
    }

    private HiveCnfHelper() {
    }
}

