/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.query.AbstractPrioritizedCallable;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.PrioritizedCallable;
import org.apache.druid.query.PrioritizedExecutorService;
import org.apache.druid.query.PrioritizedRunnable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PrioritizedExecutorServiceTest {
    private PrioritizedExecutorService exec;
    private CountDownLatch latch;
    private CountDownLatch finishLatch;
    private final boolean useFifo;
    private final DruidProcessingConfig config;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{true}, (Object)new Object[]{false});
    }

    public PrioritizedExecutorServiceTest(final boolean useFifo) {
        this.useFifo = useFifo;
        this.config = new DruidProcessingConfig(){

            public String getFormatString() {
                return null;
            }

            public boolean isFifo() {
                return useFifo;
            }
        };
    }

    @Before
    public void setUp() {
        this.exec = PrioritizedExecutorService.create((Lifecycle)new Lifecycle(), (DruidProcessingConfig)new DruidProcessingConfig(){

            public String getFormatString() {
                return "test";
            }

            public int getNumThreads() {
                return 1;
            }

            public boolean isFifo() {
                return PrioritizedExecutorServiceTest.this.useFifo;
            }
        });
        this.latch = new CountDownLatch(1);
        this.finishLatch = new CountDownLatch(3);
    }

    @After
    public void tearDown() {
        this.exec.shutdownNow();
    }

    @Test
    public void testSubmit() throws Exception {
        final ConcurrentLinkedQueue order = new ConcurrentLinkedQueue();
        this.exec.submit((Callable)new AbstractPrioritizedCallable<Void>(0){

            public Void call() throws Exception {
                PrioritizedExecutorServiceTest.this.latch.await();
                return null;
            }
        });
        this.exec.submit((Callable)new AbstractPrioritizedCallable<Void>(-1){

            public Void call() {
                order.add(-1);
                PrioritizedExecutorServiceTest.this.finishLatch.countDown();
                return null;
            }
        });
        this.exec.submit((Callable)new AbstractPrioritizedCallable<Void>(0){

            public Void call() {
                order.add(0);
                PrioritizedExecutorServiceTest.this.finishLatch.countDown();
                return null;
            }
        });
        this.exec.submit((Callable)new AbstractPrioritizedCallable<Void>(2){

            public Void call() {
                order.add(2);
                PrioritizedExecutorServiceTest.this.finishLatch.countDown();
                return null;
            }
        });
        this.latch.countDown();
        this.finishLatch.await();
        Assert.assertTrue((order.size() == 3 ? 1 : 0) != 0);
        ImmutableList expected = ImmutableList.of((Object)2, (Object)0, (Object)-1);
        Assert.assertEquals((Object)expected, (Object)ImmutableList.copyOf(order));
    }

    @Test
    public void testOrderedExecutionEqualPriorityRunnable() throws ExecutionException, InterruptedException {
        int numTasks = 100;
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)100);
        AtomicInteger hasRun = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            futures.add(this.exec.submit((Runnable)this.getCheckingPrioritizedRunnable(i, hasRun)));
        }
        this.latch.countDown();
        this.checkFutures(futures);
    }

    @Test
    public void testOrderedExecutionEqualPriorityCallable() throws ExecutionException, InterruptedException {
        int numTasks = 1000;
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)1000);
        AtomicInteger hasRun = new AtomicInteger(0);
        for (int i = 0; i < 1000; ++i) {
            futures.add(this.exec.submit(this.getCheckingPrioritizedCallable(i, hasRun)));
        }
        this.latch.countDown();
        this.checkFutures(futures);
    }

    @Test
    public void testOrderedExecutionEqualPriorityMix() throws ExecutionException, InterruptedException {
        this.exec = new PrioritizedExecutorService(this.exec.threadPoolExecutor, true, 0, this.config);
        int numTasks = 1000;
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)1000);
        AtomicInteger hasRun = new AtomicInteger(0);
        Random random = new Random(789401L);
        block6: for (int i = 0; i < 1000; ++i) {
            switch (random.nextInt(4)) {
                case 0: {
                    futures.add(this.exec.submit(this.getCheckingPrioritizedCallable(i, hasRun)));
                    continue block6;
                }
                case 1: {
                    futures.add(this.exec.submit((Runnable)this.getCheckingPrioritizedRunnable(i, hasRun)));
                    continue block6;
                }
                case 2: {
                    futures.add(this.exec.submit(this.getCheckingCallable(i, hasRun)));
                    continue block6;
                }
                case 3: {
                    futures.add(this.exec.submit(this.getCheckingRunnable(i, hasRun)));
                    continue block6;
                }
                default: {
                    Assert.fail((String)"Bad random result");
                }
            }
        }
        this.latch.countDown();
        this.checkFutures(futures);
    }

    @Test
    public void testOrderedExecutionMultiplePriorityMix() throws ExecutionException, InterruptedException {
        boolean _default = false;
        int min = -1;
        boolean max = true;
        this.exec = new PrioritizedExecutorService(this.exec.threadPoolExecutor, true, 0, this.config);
        int numTasks = 999;
        int[] priorities = new int[]{1, 0, -1};
        int tasksPerPriority = 999 / priorities.length;
        int[] priorityOffsets = new int[]{0, tasksPerPriority, tasksPerPriority * 2};
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)999);
        AtomicInteger hasRun = new AtomicInteger(0);
        Random random = new Random(789401L);
        for (int i = 0; i < 999; ++i) {
            int priorityBucket = i % priorities.length;
            int myPriority = priorities[priorityBucket];
            int priorityOffset = priorityOffsets[priorityBucket];
            int expectedPriorityOrder = i / priorities.length;
            if (random.nextBoolean()) {
                futures.add(this.exec.submit(this.getCheckingPrioritizedCallable(priorityOffset + expectedPriorityOrder, hasRun, myPriority)));
                continue;
            }
            futures.add(this.exec.submit((Runnable)this.getCheckingPrioritizedRunnable(priorityOffset + expectedPriorityOrder, hasRun, myPriority)));
        }
        this.latch.countDown();
        this.checkFutures(futures);
    }

    private void checkFutures(Iterable<ListenableFuture<?>> futures) throws InterruptedException, ExecutionException {
        for (ListenableFuture<?> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof AssumptionViolatedException) continue;
                throw e;
            }
        }
    }

    private PrioritizedCallable<Boolean> getCheckingPrioritizedCallable(int myOrder, AtomicInteger hasRun) {
        return this.getCheckingPrioritizedCallable(myOrder, hasRun, 0);
    }

    private PrioritizedCallable<Boolean> getCheckingPrioritizedCallable(int myOrder, AtomicInteger hasRun, int priority) {
        final Callable<Boolean> delegate = this.getCheckingCallable(myOrder, hasRun);
        return new AbstractPrioritizedCallable<Boolean>(priority){

            public Boolean call() throws Exception {
                return (Boolean)delegate.call();
            }
        };
    }

    private Callable<Boolean> getCheckingCallable(int myOrder, AtomicInteger hasRun) {
        final Runnable runnable = this.getCheckingRunnable(myOrder, hasRun);
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                runnable.run();
                return true;
            }
        };
    }

    private Runnable getCheckingRunnable(final int myOrder, final AtomicInteger hasRun) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    PrioritizedExecutorServiceTest.this.latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                if (PrioritizedExecutorServiceTest.this.useFifo) {
                    Assert.assertEquals((long)myOrder, (long)hasRun.getAndIncrement());
                } else {
                    Assume.assumeTrue((Integer.compare(myOrder, hasRun.getAndIncrement()) == 0 ? 1 : 0) != 0);
                }
            }
        };
    }

    private PrioritizedRunnable getCheckingPrioritizedRunnable(int myOrder, AtomicInteger hasRun) {
        return this.getCheckingPrioritizedRunnable(myOrder, hasRun, 0);
    }

    private PrioritizedRunnable getCheckingPrioritizedRunnable(int myOrder, AtomicInteger hasRun, final int priority) {
        final Runnable delegate = this.getCheckingRunnable(myOrder, hasRun);
        return new PrioritizedRunnable(){

            public int getPriority() {
                return priority;
            }

            public void run() {
                delegate.run();
            }
        };
    }
}

