/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Suppliers;
import java.nio.ByteBuffer;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.search.SearchQueryConfig;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.search.SearchQueryRunnerFactory;
import org.apache.druid.query.search.SearchStrategySelector;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.segment.Segment;

public class TestQueryRunners {
    private static final TopNQueryConfig TOPN_CONFIG = new TopNQueryConfig();

    public static CloseableStupidPool<ByteBuffer> createDefaultNonBlockingPool() {
        return new CloseableStupidPool("TestQueryRunners-bufferPool", () -> ByteBuffer.allocate(0xA00000));
    }

    public static <T> QueryRunner<T> makeTopNQueryRunner(Segment adapter, NonBlockingPool<ByteBuffer> pool) {
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, new TopNQueryQueryToolChest(TOPN_CONFIG), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeTimeSeriesQueryRunner(Segment adapter) {
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeSearchQueryRunner(Segment adapter) {
        SearchQueryConfig config = new SearchQueryConfig();
        SearchQueryRunnerFactory factory = new SearchQueryRunnerFactory(new SearchStrategySelector(Suppliers.ofInstance((Object)config)), new SearchQueryQueryToolChest(config), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeTimeBoundaryQueryRunner(Segment adapter) {
        TimeBoundaryQueryRunnerFactory factory = new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }
}

