/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleMaxAggregationTest {
    private DoubleMaxAggregatorFactory doubleMaxAggFactory;
    private DoubleMaxAggregatorFactory doubleMaxVectorAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private VectorColumnSelectorFactory vectorColumnSelectorFactory;
    private TestDoubleColumnSelectorImpl selector;
    private double[] values = new double[]{1.1, 2.7, 3.5, 1.3};
    private final double[] doubleValues1 = new double[]{5.0, 2.0, 4.0, 100.0, 1.0, 5.0, -2.0, -3.0, 0.0, 55.0};

    public DoubleMaxAggregationTest() throws Exception {
        String aggSpecJson = "{\"type\": \"doubleMax\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        this.doubleMaxAggFactory = (DoubleMaxAggregatorFactory)TestHelper.makeJsonMapper().readValue(aggSpecJson, DoubleMaxAggregatorFactory.class);
        String vectorAggSpecJson = "{\"type\": \"doubleMax\", \"name\": \"dbl\", \"fieldName\": \"dblFld\"}";
        this.doubleMaxVectorAggFactory = (DoubleMaxAggregatorFactory)TestHelper.makeJsonMapper().readValue(vectorAggSpecJson, DoubleMaxAggregatorFactory.class);
    }

    @Before
    public void setup() {
        NullHandling.initializeForTests();
        this.selector = new TestDoubleColumnSelectorImpl(this.values);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.selector);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
        VectorValueSelector vectorValueSelector = (VectorValueSelector)EasyMock.createMock(VectorValueSelector.class);
        EasyMock.expect((Object)vectorValueSelector.getDoubleVector()).andReturn((Object)this.doubleValues1).anyTimes();
        EasyMock.expect((Object)vectorValueSelector.getNullVector()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{vectorValueSelector});
        this.vectorColumnSelectorFactory = (VectorColumnSelectorFactory)EasyMock.createMock(VectorColumnSelectorFactory.class);
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.getColumnCapabilities("dblFld")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ValueType.DOUBLE).setDictionaryEncoded(true)).anyTimes();
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.makeValueSelector("dblFld")).andReturn((Object)vectorValueSelector).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.vectorColumnSelectorFactory});
    }

    @Test
    public void testDoubleMaxAggregator() {
        Aggregator agg = this.doubleMaxAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        Assert.assertEquals((double)this.values[2], (double)((Double)agg.get()), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.values[2]), (long)agg.getLong());
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testDoubleMaxBufferAggregator() {
        BufferAggregator agg = this.doubleMaxAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[9]);
        agg.init(buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        Assert.assertEquals((double)this.values[2], (double)((Double)agg.get(buffer, 0)), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.values[2]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testDoubleMaxVectorAggregator() {
        Assert.assertTrue((boolean)this.doubleMaxVectorAggFactory.canVectorize((ColumnInspector)this.vectorColumnSelectorFactory));
        VectorValueSelector vectorValueSelector = this.doubleMaxVectorAggFactory.vectorSelector(this.vectorColumnSelectorFactory);
        Assert.assertEquals((Object)this.doubleValues1, (Object)vectorValueSelector.getDoubleVector());
        VectorAggregator vectorAggregator = this.doubleMaxVectorAggFactory.factorizeVector(this.vectorColumnSelectorFactory);
        ByteBuffer buf = ByteBuffer.allocate(this.doubleMaxVectorAggFactory.getMaxIntermediateSizeWithNulls() * 3);
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 3);
        Assert.assertEquals((Object)this.doubleValues1[0], (Object)vectorAggregator.get(buf, 0));
        vectorAggregator.init(buf, 8);
        vectorAggregator.aggregate(buf, 8, 0, 3);
        Assert.assertEquals((Object)this.doubleValues1[0], (Object)vectorAggregator.get(buf, 8));
        vectorAggregator.init(buf, 16);
        vectorAggregator.aggregate(buf, 16, 4, 7);
        Assert.assertEquals((Object)this.doubleValues1[5], (Object)vectorAggregator.get(buf, 16));
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 10);
        Assert.assertEquals((Object)this.doubleValues1[3], (Object)vectorAggregator.get(buf, 0));
    }

    @Test
    public void testCombine() {
        Assert.assertEquals((double)3.4, (double)((Double)this.doubleMaxAggFactory.combine((Object)1.2, (Object)3.4)), (double)1.0E-4);
    }

    @Test
    public void testEqualsAndHashCode() {
        DoubleMaxAggregatorFactory one = new DoubleMaxAggregatorFactory("name1", "fieldName1");
        DoubleMaxAggregatorFactory oneMore = new DoubleMaxAggregatorFactory("name1", "fieldName1");
        DoubleMaxAggregatorFactory two = new DoubleMaxAggregatorFactory("name2", "fieldName2");
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    private void aggregate(TestDoubleColumnSelectorImpl selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestDoubleColumnSelectorImpl selector, BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

