/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatMinAggregationTest {
    private final FloatMinAggregatorFactory floatMinAggregatorFactory;
    private VectorColumnSelectorFactory vectorColumnSelectorFactory;
    private final float[] floatValues1 = new float[]{5.0f, 2.0f, 4.0f, 100.0f, 1.0f, 5.0f, -2.0f, -3.0f, 0.0f, 55.0f};

    public FloatMinAggregationTest() throws Exception {
        String vectorAggSpecJson = "{\"type\": \"floatMin\", \"name\": \"flt\", \"fieldName\": \"fltFld\"}";
        this.floatMinAggregatorFactory = (FloatMinAggregatorFactory)TestHelper.makeJsonMapper().readValue(vectorAggSpecJson, FloatMinAggregatorFactory.class);
    }

    @Before
    public void setup() {
        NullHandling.initializeForTests();
        VectorValueSelector vectorValueSelector = (VectorValueSelector)EasyMock.createMock(VectorValueSelector.class);
        EasyMock.expect((Object)vectorValueSelector.getFloatVector()).andReturn((Object)this.floatValues1).anyTimes();
        EasyMock.expect((Object)vectorValueSelector.getNullVector()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{vectorValueSelector});
        this.vectorColumnSelectorFactory = (VectorColumnSelectorFactory)EasyMock.createMock(VectorColumnSelectorFactory.class);
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.getColumnCapabilities("fltFld")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ValueType.FLOAT).setDictionaryEncoded(true)).anyTimes();
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.makeValueSelector("fltFld")).andReturn((Object)vectorValueSelector).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.vectorColumnSelectorFactory});
    }

    @Test
    public void testFloatMinVectorAggregator() {
        Assert.assertTrue((boolean)this.floatMinAggregatorFactory.canVectorize((ColumnInspector)this.vectorColumnSelectorFactory));
        VectorValueSelector vectorValueSelector = this.floatMinAggregatorFactory.vectorSelector(this.vectorColumnSelectorFactory);
        Assert.assertEquals((Object)this.floatValues1, (Object)vectorValueSelector.getFloatVector());
        VectorAggregator vectorAggregator = this.floatMinAggregatorFactory.factorizeVector(this.vectorColumnSelectorFactory);
        ByteBuffer buf = ByteBuffer.allocate(this.floatMinAggregatorFactory.getMaxIntermediateSizeWithNulls() * 3);
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 3);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[1]), (Object)vectorAggregator.get(buf, 0));
        vectorAggregator.init(buf, 4);
        vectorAggregator.aggregate(buf, 4, 0, 3);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[1]), (Object)vectorAggregator.get(buf, 4));
        vectorAggregator.init(buf, 8);
        vectorAggregator.aggregate(buf, 8, 3, 7);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[6]), (Object)vectorAggregator.get(buf, 8));
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 10);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[7]), (Object)vectorAggregator.get(buf, 0));
    }
}

